import { normalizeThinkLevel } from "../../auto-reply/thinking.js";
function extractSupportedValues(raw) {
    const match = raw.match(/supported values are:\s*([^\n.]+)/i) ?? raw.match(/supported values:\s*([^\n.]+)/i);
    if (!match?.[1])
        return [];
    const fragment = match[1];
    const quoted = Array.from(fragment.matchAll(/['"]([^'"]+)['"]/g)).map((entry) => entry[1]?.trim());
    if (quoted.length > 0) {
        return quoted.filter((entry) => Boolean(entry));
    }
    return fragment
        .split(/,|\band\b/gi)
        .map((entry) => entry.replace(/^[^a-zA-Z]+|[^a-zA-Z]+$/g, "").trim())
        .filter(Boolean);
}
export function pickFallbackThinkingLevel(params) {
    const raw = params.message?.trim();
    if (!raw)
        return undefined;
    const supported = extractSupportedValues(raw);
    if (supported.length === 0)
        return undefined;
    for (const entry of supported) {
        const normalized = normalizeThinkLevel(entry);
        if (!normalized)
            continue;
        if (params.attempted.has(normalized))
            continue;
        return normalized;
    }
    return undefined;
}
