import { pruneContextMessages } from "./pruner.js";
import { getContextPruningRuntime } from "./runtime.js";
export default function contextPruningExtension(api) {
    api.on("context", (event, ctx) => {
        const runtime = getContextPruningRuntime(ctx.sessionManager);
        if (!runtime)
            return undefined;
        if (runtime.settings.mode === "cache-ttl") {
            const ttlMs = runtime.settings.ttlMs;
            const lastTouch = runtime.lastCacheTouchAt ?? null;
            if (!lastTouch || ttlMs <= 0) {
                return undefined;
            }
            if (ttlMs > 0 && Date.now() - lastTouch < ttlMs) {
                return undefined;
            }
        }
        const next = pruneContextMessages({
            messages: event.messages,
            settings: runtime.settings,
            ctx,
            isToolPrunable: runtime.isToolPrunable,
            contextWindowTokensOverride: runtime.contextWindowTokens ?? undefined,
        });
        if (next === event.messages)
            return undefined;
        if (runtime.settings.mode === "cache-ttl") {
            runtime.lastCacheTouchAt = Date.now();
        }
        return { messages: next };
    });
}
