function formatMediaAttachedLine(params) {
    const prefix = typeof params.index === "number" && typeof params.total === "number"
        ? `[media attached ${params.index}/${params.total}: `
        : "[media attached: ";
    const typePart = params.type?.trim() ? ` (${params.type.trim()})` : "";
    const urlRaw = params.url?.trim();
    const urlPart = urlRaw ? ` | ${urlRaw}` : "";
    return `${prefix}${params.path}${typePart}${urlPart}]`;
}
export function buildInboundMediaNote(ctx) {
    // Attachment indices follow MediaPaths/MediaUrls ordering as supplied by the channel.
    const suppressed = new Set();
    if (Array.isArray(ctx.MediaUnderstanding)) {
        for (const output of ctx.MediaUnderstanding) {
            suppressed.add(output.attachmentIndex);
        }
    }
    if (Array.isArray(ctx.MediaUnderstandingDecisions)) {
        for (const decision of ctx.MediaUnderstandingDecisions) {
            if (decision.outcome !== "success")
                continue;
            for (const attachment of decision.attachments) {
                if (attachment.chosen?.outcome === "success") {
                    suppressed.add(attachment.attachmentIndex);
                }
            }
        }
    }
    const pathsFromArray = Array.isArray(ctx.MediaPaths) ? ctx.MediaPaths : undefined;
    const paths = pathsFromArray && pathsFromArray.length > 0
        ? pathsFromArray
        : ctx.MediaPath?.trim()
            ? [ctx.MediaPath.trim()]
            : [];
    if (paths.length === 0)
        return undefined;
    const urls = Array.isArray(ctx.MediaUrls) && ctx.MediaUrls.length === paths.length
        ? ctx.MediaUrls
        : undefined;
    const types = Array.isArray(ctx.MediaTypes) && ctx.MediaTypes.length === paths.length
        ? ctx.MediaTypes
        : undefined;
    const entries = paths
        .map((entry, index) => ({
        path: entry ?? "",
        type: types?.[index] ?? ctx.MediaType,
        url: urls?.[index] ?? ctx.MediaUrl,
        index,
    }))
        .filter((entry) => !suppressed.has(entry.index));
    if (entries.length === 0)
        return undefined;
    if (entries.length === 1) {
        return formatMediaAttachedLine({
            path: entries[0]?.path ?? "",
            type: entries[0]?.type,
            url: entries[0]?.url,
        });
    }
    const count = entries.length;
    const lines = [`[media attached: ${count} files]`];
    for (const [idx, entry] of entries.entries()) {
        lines.push(formatMediaAttachedLine({
            path: entry.path,
            index: idx + 1,
            total: count,
            type: entry.type,
            url: entry.url,
        }));
    }
    return lines.join("\n");
}
