import { buildStatusReply } from "./commands.js";
import { applyInlineDirectivesFastLane, handleDirectiveOnly, isDirectiveOnly, persistInlineDirectives, } from "./directive-handling.js";
export async function applyInlineDirectiveOverrides(params) {
    const { ctx, cfg, agentId, agentDir, agentCfg, sessionEntry, sessionStore, sessionKey, storePath, sessionScope, isGroup, allowTextCommands, command, messageProviderKey, elevatedEnabled, elevatedAllowed, elevatedFailures, defaultProvider, defaultModel, aliasIndex, modelState, initialModelLabel, formatModelSwitchEvent, resolvedElevatedLevel, defaultActivation, typing, effectiveModelDirective, } = params;
    let { directives } = params;
    let { provider, model } = params;
    let { contextTokens } = params;
    let directiveAck;
    if (!command.isAuthorizedSender) {
        directives = {
            ...directives,
            hasThinkDirective: false,
            hasVerboseDirective: false,
            hasReasoningDirective: false,
            hasElevatedDirective: false,
            hasExecDirective: false,
            execHost: undefined,
            execSecurity: undefined,
            execAsk: undefined,
            execNode: undefined,
            rawExecHost: undefined,
            rawExecSecurity: undefined,
            rawExecAsk: undefined,
            rawExecNode: undefined,
            hasExecOptions: false,
            invalidExecHost: false,
            invalidExecSecurity: false,
            invalidExecAsk: false,
            invalidExecNode: false,
            hasStatusDirective: false,
            hasModelDirective: false,
            hasQueueDirective: false,
            queueReset: false,
        };
    }
    if (isDirectiveOnly({
        directives,
        cleanedBody: directives.cleaned,
        ctx,
        cfg,
        agentId,
        isGroup,
    })) {
        if (!command.isAuthorizedSender) {
            typing.cleanup();
            return { kind: "reply", reply: undefined };
        }
        const resolvedDefaultThinkLevel = sessionEntry?.thinkingLevel ??
            agentCfg?.thinkingDefault ??
            (await modelState.resolveDefaultThinkingLevel());
        const currentThinkLevel = resolvedDefaultThinkLevel;
        const currentVerboseLevel = sessionEntry?.verboseLevel ??
            agentCfg?.verboseDefault;
        const currentReasoningLevel = sessionEntry?.reasoningLevel ?? "off";
        const currentElevatedLevel = sessionEntry?.elevatedLevel ??
            agentCfg?.elevatedDefault;
        const directiveReply = await handleDirectiveOnly({
            cfg,
            directives,
            sessionEntry,
            sessionStore,
            sessionKey,
            storePath,
            elevatedEnabled,
            elevatedAllowed,
            elevatedFailures,
            messageProviderKey,
            defaultProvider,
            defaultModel,
            aliasIndex,
            allowedModelKeys: modelState.allowedModelKeys,
            allowedModelCatalog: modelState.allowedModelCatalog,
            resetModelOverride: modelState.resetModelOverride,
            provider,
            model,
            initialModelLabel,
            formatModelSwitchEvent,
            currentThinkLevel,
            currentVerboseLevel,
            currentReasoningLevel,
            currentElevatedLevel,
        });
        let statusReply;
        if (directives.hasStatusDirective && allowTextCommands && command.isAuthorizedSender) {
            statusReply = await buildStatusReply({
                cfg,
                command,
                sessionEntry,
                sessionKey,
                sessionScope,
                provider,
                model,
                contextTokens,
                resolvedThinkLevel: resolvedDefaultThinkLevel,
                resolvedVerboseLevel: (currentVerboseLevel ?? "off"),
                resolvedReasoningLevel: (currentReasoningLevel ?? "off"),
                resolvedElevatedLevel,
                resolveDefaultThinkingLevel: async () => resolvedDefaultThinkLevel,
                isGroup,
                defaultGroupActivation: defaultActivation,
                mediaDecisions: ctx.MediaUnderstandingDecisions,
            });
        }
        typing.cleanup();
        if (statusReply?.text && directiveReply?.text) {
            return {
                kind: "reply",
                reply: { text: `${directiveReply.text}\n${statusReply.text}` },
            };
        }
        return { kind: "reply", reply: statusReply ?? directiveReply };
    }
    const hasAnyDirective = directives.hasThinkDirective ||
        directives.hasVerboseDirective ||
        directives.hasReasoningDirective ||
        directives.hasElevatedDirective ||
        directives.hasExecDirective ||
        directives.hasModelDirective ||
        directives.hasQueueDirective ||
        directives.hasStatusDirective;
    if (hasAnyDirective && command.isAuthorizedSender) {
        const fastLane = await applyInlineDirectivesFastLane({
            directives,
            commandAuthorized: command.isAuthorizedSender,
            ctx,
            cfg,
            agentId,
            isGroup,
            sessionEntry,
            sessionStore,
            sessionKey,
            storePath,
            elevatedEnabled,
            elevatedAllowed,
            elevatedFailures,
            messageProviderKey,
            defaultProvider,
            defaultModel,
            aliasIndex,
            allowedModelKeys: modelState.allowedModelKeys,
            allowedModelCatalog: modelState.allowedModelCatalog,
            resetModelOverride: modelState.resetModelOverride,
            provider,
            model,
            initialModelLabel,
            formatModelSwitchEvent,
            agentCfg,
            modelState: {
                resolveDefaultThinkingLevel: modelState.resolveDefaultThinkingLevel,
                allowedModelKeys: modelState.allowedModelKeys,
                allowedModelCatalog: modelState.allowedModelCatalog,
                resetModelOverride: modelState.resetModelOverride,
            },
        });
        directiveAck = fastLane.directiveAck;
        provider = fastLane.provider;
        model = fastLane.model;
    }
    const persisted = await persistInlineDirectives({
        directives,
        effectiveModelDirective,
        cfg,
        agentDir,
        sessionEntry,
        sessionStore,
        sessionKey,
        storePath,
        elevatedEnabled,
        elevatedAllowed,
        defaultProvider,
        defaultModel,
        aliasIndex,
        allowedModelKeys: modelState.allowedModelKeys,
        provider,
        model,
        initialModelLabel,
        formatModelSwitchEvent,
        agentCfg,
    });
    provider = persisted.provider;
    model = persisted.model;
    contextTokens = persisted.contextTokens;
    const perMessageQueueMode = directives.hasQueueDirective && !directives.queueReset ? directives.queueMode : undefined;
    const perMessageQueueOptions = directives.hasQueueDirective && !directives.queueReset
        ? {
            debounceMs: directives.debounceMs,
            cap: directives.cap,
            dropPolicy: directives.dropPolicy,
        }
        : undefined;
    return {
        kind: "continue",
        directives,
        provider,
        model,
        contextTokens,
        directiveAck,
        perMessageQueueMode,
        perMessageQueueOptions,
    };
}
