import { getChannelPlugin, listChannelPlugins } from "./index.js";
export function listChannelMessageActions(cfg) {
    const actions = new Set(["send", "broadcast"]);
    for (const plugin of listChannelPlugins()) {
        const list = plugin.actions?.listActions?.({ cfg });
        if (!list)
            continue;
        for (const action of list)
            actions.add(action);
    }
    return Array.from(actions);
}
export function supportsChannelMessageButtons(cfg) {
    for (const plugin of listChannelPlugins()) {
        if (plugin.actions?.supportsButtons?.({ cfg }))
            return true;
    }
    return false;
}
export function supportsChannelMessageCards(cfg) {
    for (const plugin of listChannelPlugins()) {
        if (plugin.actions?.supportsCards?.({ cfg }))
            return true;
    }
    return false;
}
export async function dispatchChannelMessageAction(ctx) {
    const plugin = getChannelPlugin(ctx.channel);
    if (!plugin?.actions?.handleAction)
        return null;
    if (plugin.actions.supportsAction && !plugin.actions.supportsAction({ action: ctx.action })) {
        return null;
    }
    return await plugin.actions.handleAction(ctx);
}
