import { chunkText } from "../../../auto-reply/chunk.js";
import { sendMessageSignal } from "../../../signal/send.js";
import { resolveChannelMediaMaxBytes } from "../media-limits.js";
export const signalOutbound = {
    deliveryMode: "direct",
    chunker: chunkText,
    chunkerMode: "text",
    textChunkLimit: 4000,
    sendText: async ({ cfg, to, text, accountId, deps }) => {
        const send = deps?.sendSignal ?? sendMessageSignal;
        const maxBytes = resolveChannelMediaMaxBytes({
            cfg,
            resolveChannelLimitMb: ({ cfg, accountId }) => cfg.channels?.signal?.accounts?.[accountId]?.mediaMaxMb ?? cfg.channels?.signal?.mediaMaxMb,
            accountId,
        });
        const result = await send(to, text, {
            maxBytes,
            accountId: accountId ?? undefined,
        });
        return { channel: "signal", ...result };
    },
    sendMedia: async ({ cfg, to, text, mediaUrl, accountId, deps }) => {
        const send = deps?.sendSignal ?? sendMessageSignal;
        const maxBytes = resolveChannelMediaMaxBytes({
            cfg,
            resolveChannelLimitMb: ({ cfg, accountId }) => cfg.channels?.signal?.accounts?.[accountId]?.mediaMaxMb ?? cfg.channels?.signal?.mediaMaxMb,
            accountId,
        });
        const result = await send(to, text, {
            mediaUrl,
            maxBytes,
            accountId: accountId ?? undefined,
        });
        return { channel: "signal", ...result };
    },
};
