import { resolveChannelDefaultAccountId } from "../channels/plugins/helpers.js";
import { getChannelPlugin, normalizeChannelId } from "../channels/plugins/index.js";
import { DEFAULT_CHAT_CHANNEL } from "../channels/registry.js";
import { loadConfig } from "../config/config.js";
import { setVerbose } from "../globals.js";
import { defaultRuntime } from "../runtime.js";
export async function runChannelLogin(opts, runtime = defaultRuntime) {
    const channelInput = opts.channel ?? DEFAULT_CHAT_CHANNEL;
    const channelId = normalizeChannelId(channelInput);
    if (!channelId) {
        throw new Error(`Unsupported channel: ${channelInput}`);
    }
    const plugin = getChannelPlugin(channelId);
    if (!plugin?.auth?.login) {
        throw new Error(`Channel ${channelId} does not support login`);
    }
    // Auth-only flow: do not mutate channel config here.
    setVerbose(Boolean(opts.verbose));
    const cfg = loadConfig();
    const accountId = opts.account?.trim() || resolveChannelDefaultAccountId({ plugin, cfg });
    await plugin.auth.login({
        cfg,
        accountId,
        runtime,
        verbose: Boolean(opts.verbose),
        channelInput,
    });
}
export async function runChannelLogout(opts, runtime = defaultRuntime) {
    const channelInput = opts.channel ?? DEFAULT_CHAT_CHANNEL;
    const channelId = normalizeChannelId(channelInput);
    if (!channelId) {
        throw new Error(`Unsupported channel: ${channelInput}`);
    }
    const plugin = getChannelPlugin(channelId);
    if (!plugin?.gateway?.logoutAccount) {
        throw new Error(`Channel ${channelId} does not support logout`);
    }
    // Auth-only flow: resolve account + clear session state only.
    const cfg = loadConfig();
    const accountId = opts.account?.trim() || resolveChannelDefaultAccountId({ plugin, cfg });
    const account = plugin.config.resolveAccount(cfg, accountId);
    await plugin.gateway.logoutAccount({
        cfg,
        accountId,
        account,
        runtime,
    });
}
