import { normalizeProfileName } from "./profile-utils.js";
import { replaceCliName, resolveCliName } from "./cli-name.js";
const CLI_PREFIX_RE = /^(?:pnpm|npm|bunx|npx)\s+openclaw\b|^openclaw\b/;
const PROFILE_FLAG_RE = /(?:^|\s)--profile(?:\s|=|$)/;
const DEV_FLAG_RE = /(?:^|\s)--dev(?:\s|$)/;
export function formatCliCommand(command, env = process.env) {
    const cliName = resolveCliName();
    const normalizedCommand = replaceCliName(command, cliName);
    const profile = normalizeProfileName(env.OPENCLAW_PROFILE);
    if (!profile)
        return normalizedCommand;
    if (!CLI_PREFIX_RE.test(normalizedCommand))
        return normalizedCommand;
    if (PROFILE_FLAG_RE.test(normalizedCommand) || DEV_FLAG_RE.test(normalizedCommand)) {
        return normalizedCommand;
    }
    return normalizedCommand.replace(CLI_PREFIX_RE, (match) => `${match} --profile ${profile}`);
}
