const AUTH_CHOICE_GROUP_DEFS = [
    {
        value: "openai",
        label: "OpenAI",
        hint: "Codex OAuth + API key",
        choices: ["openai-codex", "openai-api-key"],
    },
    {
        value: "anthropic",
        label: "Anthropic",
        hint: "setup-token + API key",
        choices: ["token", "apiKey"],
    },
    {
        value: "minimax",
        label: "MiniMax",
        hint: "M2.1 (recommended)",
        choices: ["minimax-api", "minimax-api-lightning"],
    },
    {
        value: "qwen",
        label: "Qwen",
        hint: "OAuth",
        choices: ["qwen-portal"],
    },
    {
        value: "synthetic",
        label: "Synthetic",
        hint: "Anthropic-compatible (multi-model)",
        choices: ["synthetic-api-key"],
    },
    {
        value: "venice",
        label: "Venice AI",
        hint: "Privacy-focused (uncensored models)",
        choices: ["venice-api-key"],
    },
    {
        value: "google",
        label: "Google",
        hint: "Gemini API key + OAuth",
        choices: ["gemini-api-key", "google-antigravity", "google-gemini-cli"],
    },
    {
        value: "copilot",
        label: "Copilot",
        hint: "GitHub + local proxy",
        choices: ["github-copilot", "copilot-proxy"],
    },
    {
        value: "openrouter",
        label: "OpenRouter",
        hint: "API key",
        choices: ["openrouter-api-key"],
    },
    {
        value: "ai-gateway",
        label: "Vercel AI Gateway",
        hint: "API key",
        choices: ["ai-gateway-api-key"],
    },
    {
        value: "moonshot",
        label: "Moonshot AI",
        hint: "Kimi K2 + Kimi Code",
        choices: ["moonshot-api-key", "kimi-code-api-key"],
    },
    {
        value: "zai",
        label: "Z.AI (GLM 4.7)",
        hint: "API key",
        choices: ["zai-api-key"],
    },
    {
        value: "xiaomi",
        label: "Xiaomi",
        hint: "API key",
        choices: ["xiaomi-api-key"],
    },
    {
        value: "opencode-zen",
        label: "OpenCode Zen",
        hint: "API key",
        choices: ["opencode-zen"],
    },
];
export function buildAuthChoiceOptions(params) {
    void params.store;
    const options = [];
    options.push({
        value: "token",
        label: "Anthropic token (paste setup-token)",
        hint: "run `claude setup-token` elsewhere, then paste the token here",
    });
    options.push({
        value: "openai-codex",
        label: "OpenAI Codex (ChatGPT OAuth)",
    });
    options.push({ value: "chutes", label: "Chutes (OAuth)" });
    options.push({ value: "openai-api-key", label: "OpenAI API key" });
    options.push({ value: "openrouter-api-key", label: "OpenRouter API key" });
    options.push({
        value: "ai-gateway-api-key",
        label: "Vercel AI Gateway API key",
    });
    options.push({ value: "moonshot-api-key", label: "Moonshot AI API key" });
    options.push({ value: "kimi-code-api-key", label: "Kimi Code API key" });
    options.push({ value: "synthetic-api-key", label: "Synthetic API key" });
    options.push({
        value: "venice-api-key",
        label: "Venice AI API key",
        hint: "Privacy-focused inference (uncensored models)",
    });
    options.push({
        value: "github-copilot",
        label: "GitHub Copilot (GitHub device login)",
        hint: "Uses GitHub device flow",
    });
    options.push({ value: "gemini-api-key", label: "Google Gemini API key" });
    options.push({
        value: "google-antigravity",
        label: "Google Antigravity OAuth",
        hint: "Uses the bundled Antigravity auth plugin",
    });
    options.push({
        value: "google-gemini-cli",
        label: "Google Gemini CLI OAuth",
        hint: "Uses the bundled Gemini CLI auth plugin",
    });
    options.push({ value: "zai-api-key", label: "Z.AI (GLM 4.7) API key" });
    options.push({
        value: "xiaomi-api-key",
        label: "Xiaomi API key",
    });
    options.push({ value: "qwen-portal", label: "Qwen OAuth" });
    options.push({
        value: "copilot-proxy",
        label: "Copilot Proxy (local)",
        hint: "Local proxy for VS Code Copilot models",
    });
    options.push({ value: "apiKey", label: "Anthropic API key" });
    // Token flow is currently Anthropic-only; use CLI for advanced providers.
    options.push({
        value: "opencode-zen",
        label: "OpenCode Zen (multi-model proxy)",
        hint: "Claude, GPT, Gemini via opencode.ai/zen",
    });
    options.push({ value: "minimax-api", label: "MiniMax M2.1" });
    options.push({
        value: "minimax-api-lightning",
        label: "MiniMax M2.1 Lightning",
        hint: "Faster, higher output cost",
    });
    if (params.includeSkip) {
        options.push({ value: "skip", label: "Skip for now" });
    }
    return options;
}
export function buildAuthChoiceGroups(params) {
    const options = buildAuthChoiceOptions({
        ...params,
        includeSkip: false,
    });
    const optionByValue = new Map(options.map((opt) => [opt.value, opt]));
    const groups = AUTH_CHOICE_GROUP_DEFS.map((group) => ({
        ...group,
        options: group.choices
            .map((choice) => optionByValue.get(choice))
            .filter((opt) => Boolean(opt)),
    }));
    const skipOption = params.includeSkip
        ? { value: "skip", label: "Skip for now" }
        : undefined;
    return { groups, skipOption };
}
