import { normalizeProviderId } from "../agents/model-selection.js";
export const ANTHROPIC_SETUP_TOKEN_PREFIX = "sk-ant-oat01-";
export const ANTHROPIC_SETUP_TOKEN_MIN_LENGTH = 80;
export const DEFAULT_TOKEN_PROFILE_NAME = "default";
export function normalizeTokenProfileName(raw) {
    const trimmed = raw.trim();
    if (!trimmed)
        return DEFAULT_TOKEN_PROFILE_NAME;
    const slug = trimmed
        .toLowerCase()
        .replace(/[^a-z0-9._-]+/g, "-")
        .replace(/-+/g, "-")
        .replace(/^-+|-+$/g, "");
    return slug || DEFAULT_TOKEN_PROFILE_NAME;
}
export function buildTokenProfileId(params) {
    const provider = normalizeProviderId(params.provider);
    const name = normalizeTokenProfileName(params.name);
    return `${provider}:${name}`;
}
export function validateAnthropicSetupToken(raw) {
    const trimmed = raw.trim();
    if (!trimmed)
        return "Required";
    if (!trimmed.startsWith(ANTHROPIC_SETUP_TOKEN_PREFIX)) {
        return `Expected token starting with ${ANTHROPIC_SETUP_TOKEN_PREFIX}`;
    }
    if (trimmed.length < ANTHROPIC_SETUP_TOKEN_MIN_LENGTH) {
        return "Token looks too short; paste the full setup-token";
    }
    return undefined;
}
