import fs from "node:fs";
import path from "node:path";
import { note } from "../terminal/note.js";
export function noteSourceInstallIssues(root) {
    if (!root)
        return;
    const workspaceMarker = path.join(root, "pnpm-workspace.yaml");
    if (!fs.existsSync(workspaceMarker))
        return;
    const warnings = [];
    const nodeModules = path.join(root, "node_modules");
    const pnpmStore = path.join(nodeModules, ".pnpm");
    const tsxBin = path.join(nodeModules, ".bin", "tsx");
    const srcEntry = path.join(root, "src", "entry.ts");
    if (fs.existsSync(nodeModules) && !fs.existsSync(pnpmStore)) {
        warnings.push("- node_modules was not installed by pnpm (missing node_modules/.pnpm). Run: pnpm install");
    }
    if (fs.existsSync(path.join(root, "package-lock.json"))) {
        warnings.push("- package-lock.json present in a pnpm workspace. If you ran npm install, remove it and reinstall with pnpm.");
    }
    if (fs.existsSync(srcEntry) && !fs.existsSync(tsxBin)) {
        warnings.push("- tsx binary is missing for source runs. Run: pnpm install");
    }
    if (warnings.length > 0) {
        note(warnings.join("\n"), "Install");
    }
}
