import { CHANNEL_MESSAGE_ACTION_NAMES, } from "../channels/plugins/types.js";
import { createOutboundSendDeps } from "../cli/outbound-send-deps.js";
import { withProgress } from "../cli/progress.js";
import { loadConfig } from "../config/config.js";
import { runMessageAction } from "../infra/outbound/message-action-runner.js";
import { GATEWAY_CLIENT_MODES, GATEWAY_CLIENT_NAMES } from "../utils/message-channel.js";
import { buildMessageCliJson, formatMessageCliText } from "./message-format.js";
export async function messageCommand(opts, deps, runtime) {
    const cfg = loadConfig();
    const rawAction = typeof opts.action === "string" ? opts.action.trim() : "";
    const actionInput = rawAction || "send";
    const actionMatch = CHANNEL_MESSAGE_ACTION_NAMES.find((name) => name.toLowerCase() === actionInput.toLowerCase());
    if (!actionMatch) {
        throw new Error(`Unknown message action: ${actionInput}`);
    }
    const action = actionMatch;
    const outboundDeps = createOutboundSendDeps(deps);
    const run = async () => await runMessageAction({
        cfg,
        action,
        params: opts,
        deps: outboundDeps,
        gateway: {
            clientName: GATEWAY_CLIENT_NAMES.CLI,
            mode: GATEWAY_CLIENT_MODES.CLI,
        },
    });
    const json = opts.json === true;
    const dryRun = opts.dryRun === true;
    const needsSpinner = !json && !dryRun && (action === "send" || action === "poll");
    const result = needsSpinner
        ? await withProgress({
            label: action === "poll" ? "Sending poll..." : "Sending...",
            indeterminate: true,
            enabled: true,
        }, run)
        : await run();
    if (json) {
        runtime.log(JSON.stringify(buildMessageCliJson(result), null, 2));
        return;
    }
    for (const line of formatMessageCliText(result)) {
        runtime.log(line);
    }
}
