export const formatKTokens = (value) => `${(value / 1000).toFixed(value >= 10_000 ? 0 : 1)}k`;
export const formatAge = (ms) => {
    if (!ms || ms < 0)
        return "unknown";
    const minutes = Math.round(ms / 60_000);
    if (minutes < 1)
        return "just now";
    if (minutes < 60)
        return `${minutes}m ago`;
    const hours = Math.round(minutes / 60);
    if (hours < 48)
        return `${hours}h ago`;
    const days = Math.round(hours / 24);
    return `${days}d ago`;
};
export const formatDuration = (ms) => {
    if (ms == null || !Number.isFinite(ms))
        return "unknown";
    if (ms < 1000)
        return `${Math.round(ms)}ms`;
    return `${(ms / 1000).toFixed(1)}s`;
};
export const shortenText = (value, maxLen) => {
    const chars = Array.from(value);
    if (chars.length <= maxLen)
        return value;
    return `${chars.slice(0, Math.max(0, maxLen - 1)).join("")}…`;
};
export const formatTokensCompact = (sess) => {
    const used = sess.totalTokens ?? 0;
    const ctx = sess.contextTokens;
    if (!ctx)
        return `${formatKTokens(used)} used`;
    const pctLabel = sess.percentUsed != null ? `${sess.percentUsed}%` : "?%";
    return `${formatKTokens(used)}/${formatKTokens(ctx)} (${pctLabel})`;
};
export const formatDaemonRuntimeShort = (runtime) => {
    if (!runtime)
        return null;
    const status = runtime.status ?? "unknown";
    const details = [];
    if (runtime.pid)
        details.push(`pid ${runtime.pid}`);
    if (runtime.state && runtime.state.toLowerCase() !== status) {
        details.push(`state ${runtime.state}`);
    }
    const detail = runtime.detail?.replace(/\s+/g, " ").trim() || "";
    const noisyLaunchctlDetail = runtime.missingUnit === true && detail.toLowerCase().includes("could not find service");
    if (detail && !noisyLaunchctlDetail)
        details.push(detail);
    return details.length > 0 ? `${status} (${details.join(", ")})` : status;
};
