import crypto from "node:crypto";
import { loadSessionStore, resolveStorePath } from "../../config/sessions.js";
export function resolveCronSession(params) {
    const sessionCfg = params.cfg.session;
    const storePath = resolveStorePath(sessionCfg?.store, {
        agentId: params.agentId,
    });
    const store = loadSessionStore(storePath);
    const entry = store[params.sessionKey];
    const sessionId = crypto.randomUUID();
    const systemSent = false;
    const sessionEntry = {
        sessionId,
        updatedAt: params.nowMs,
        systemSent,
        thinkingLevel: entry?.thinkingLevel,
        verboseLevel: entry?.verboseLevel,
        model: entry?.model,
        contextTokens: entry?.contextTokens,
        sendPolicy: entry?.sendPolicy,
        lastChannel: entry?.lastChannel,
        lastTo: entry?.lastTo,
        lastAccountId: entry?.lastAccountId,
        skillsSnapshot: entry?.skillsSnapshot,
    };
    return { storePath, store, sessionEntry, systemSent, isNewSession: true };
}
