import { convertMarkdownTables } from "../../markdown/tables.js";
import { chunkDiscordTextWithMode } from "../chunk.js";
import { sendMessageDiscord } from "../send.js";
export async function deliverDiscordReply(params) {
    const chunkLimit = Math.min(params.textLimit, 2000);
    for (const payload of params.replies) {
        const mediaList = payload.mediaUrls ?? (payload.mediaUrl ? [payload.mediaUrl] : []);
        const rawText = payload.text ?? "";
        const tableMode = params.tableMode ?? "code";
        const text = convertMarkdownTables(rawText, tableMode);
        if (!text && mediaList.length === 0)
            continue;
        const replyTo = params.replyToId?.trim() || undefined;
        if (mediaList.length === 0) {
            let isFirstChunk = true;
            const mode = params.chunkMode ?? "length";
            const chunks = chunkDiscordTextWithMode(text, {
                maxChars: chunkLimit,
                maxLines: params.maxLinesPerMessage,
                chunkMode: mode,
            });
            if (!chunks.length && text)
                chunks.push(text);
            for (const chunk of chunks) {
                const trimmed = chunk.trim();
                if (!trimmed)
                    continue;
                await sendMessageDiscord(params.target, trimmed, {
                    token: params.token,
                    rest: params.rest,
                    accountId: params.accountId,
                    replyTo: isFirstChunk ? replyTo : undefined,
                });
                isFirstChunk = false;
            }
            continue;
        }
        const firstMedia = mediaList[0];
        if (!firstMedia)
            continue;
        await sendMessageDiscord(params.target, text, {
            token: params.token,
            rest: params.rest,
            mediaUrl: firstMedia,
            accountId: params.accountId,
            replyTo,
        });
        for (const extra of mediaList.slice(1)) {
            await sendMessageDiscord(params.target, "", {
                token: params.token,
                rest: params.rest,
                mediaUrl: extra,
                accountId: params.accountId,
            });
        }
    }
}
