const CONTROL_UI_AVATAR_PREFIX = "/avatar";
export function normalizeControlUiBasePath(basePath) {
    if (!basePath)
        return "";
    let normalized = basePath.trim();
    if (!normalized)
        return "";
    if (!normalized.startsWith("/"))
        normalized = `/${normalized}`;
    if (normalized === "/")
        return "";
    if (normalized.endsWith("/"))
        normalized = normalized.slice(0, -1);
    return normalized;
}
export function buildControlUiAvatarUrl(basePath, agentId) {
    return basePath
        ? `${basePath}${CONTROL_UI_AVATAR_PREFIX}/${agentId}`
        : `${CONTROL_UI_AVATAR_PREFIX}/${agentId}`;
}
function looksLikeLocalAvatarPath(value) {
    if (/[\\/]/.test(value))
        return true;
    return /\.(png|jpe?g|gif|webp|svg|ico)$/i.test(value);
}
export function resolveAssistantAvatarUrl(params) {
    const avatar = params.avatar?.trim();
    if (!avatar)
        return undefined;
    if (/^https?:\/\//i.test(avatar) || /^data:image\//i.test(avatar))
        return avatar;
    const basePath = normalizeControlUiBasePath(params.basePath);
    const baseAvatarPrefix = basePath
        ? `${basePath}${CONTROL_UI_AVATAR_PREFIX}/`
        : `${CONTROL_UI_AVATAR_PREFIX}/`;
    if (basePath && avatar.startsWith(`${CONTROL_UI_AVATAR_PREFIX}/`)) {
        return `${basePath}${avatar}`;
    }
    if (avatar.startsWith(baseAvatarPrefix))
        return avatar;
    if (!params.agentId)
        return avatar;
    if (looksLikeLocalAvatarPath(avatar)) {
        return buildControlUiAvatarUrl(basePath, params.agentId);
    }
    return avatar;
}
export { CONTROL_UI_AVATAR_PREFIX };
