import { loadConfig } from "../../config/config.js";
import { ErrorCodes, errorShape, formatValidationErrors, validateAgentsListParams, } from "../protocol/index.js";
import { listAgentsForGateway } from "../session-utils.js";
export const agentsHandlers = {
    "agents.list": ({ params, respond }) => {
        if (!validateAgentsListParams(params)) {
            respond(false, undefined, errorShape(ErrorCodes.INVALID_REQUEST, `invalid agents.list params: ${formatValidationErrors(validateAgentsListParams.errors)}`));
            return;
        }
        const cfg = loadConfig();
        const result = listAgentsForGateway(cfg);
        respond(true, result, undefined);
    },
};
