import { getLogger, isFileLogLevelEnabled } from "./logging/logger.js";
import { theme } from "./terminal/theme.js";
let globalVerbose = false;
let globalYes = false;
export function setVerbose(v) {
    globalVerbose = v;
}
export function isVerbose() {
    return globalVerbose;
}
export function shouldLogVerbose() {
    return globalVerbose || isFileLogLevelEnabled("debug");
}
export function logVerbose(message) {
    if (!shouldLogVerbose())
        return;
    try {
        getLogger().debug({ message }, "verbose");
    }
    catch {
        // ignore logger failures to avoid breaking verbose printing
    }
    if (!globalVerbose)
        return;
    console.log(theme.muted(message));
}
export function logVerboseConsole(message) {
    if (!globalVerbose)
        return;
    console.log(theme.muted(message));
}
export function setYes(v) {
    globalYes = v;
}
export function isYes() {
    return globalYes;
}
export const success = theme.success;
export const warn = theme.warn;
export const info = theme.info;
export const danger = theme.error;
