import { DEFAULT_ACCOUNT_ID, normalizeAccountId } from "../routing/session-key.js";
function listConfiguredAccountIds(cfg) {
    const accounts = cfg.channels?.imessage?.accounts;
    if (!accounts || typeof accounts !== "object")
        return [];
    return Object.keys(accounts).filter(Boolean);
}
export function listIMessageAccountIds(cfg) {
    const ids = listConfiguredAccountIds(cfg);
    if (ids.length === 0)
        return [DEFAULT_ACCOUNT_ID];
    return ids.sort((a, b) => a.localeCompare(b));
}
export function resolveDefaultIMessageAccountId(cfg) {
    const ids = listIMessageAccountIds(cfg);
    if (ids.includes(DEFAULT_ACCOUNT_ID))
        return DEFAULT_ACCOUNT_ID;
    return ids[0] ?? DEFAULT_ACCOUNT_ID;
}
function resolveAccountConfig(cfg, accountId) {
    const accounts = cfg.channels?.imessage?.accounts;
    if (!accounts || typeof accounts !== "object")
        return undefined;
    return accounts[accountId];
}
function mergeIMessageAccountConfig(cfg, accountId) {
    const { accounts: _ignored, ...base } = (cfg.channels?.imessage ??
        {});
    const account = resolveAccountConfig(cfg, accountId) ?? {};
    return { ...base, ...account };
}
export function resolveIMessageAccount(params) {
    const accountId = normalizeAccountId(params.accountId);
    const baseEnabled = params.cfg.channels?.imessage?.enabled !== false;
    const merged = mergeIMessageAccountConfig(params.cfg, accountId);
    const accountEnabled = merged.enabled !== false;
    const configured = Boolean(merged.cliPath?.trim() ||
        merged.dbPath?.trim() ||
        merged.service ||
        merged.region?.trim() ||
        (merged.allowFrom && merged.allowFrom.length > 0) ||
        (merged.groupAllowFrom && merged.groupAllowFrom.length > 0) ||
        merged.dmPolicy ||
        merged.groupPolicy ||
        typeof merged.includeAttachments === "boolean" ||
        typeof merged.mediaMaxMb === "number" ||
        typeof merged.textChunkLimit === "number" ||
        (merged.groups && Object.keys(merged.groups).length > 0));
    return {
        accountId,
        enabled: baseEnabled && accountEnabled,
        name: merged.name?.trim() || undefined,
        config: merged,
        configured,
    };
}
export function listEnabledIMessageAccounts(cfg) {
    return listIMessageAccountIds(cfg)
        .map((accountId) => resolveIMessageAccount({ cfg, accountId }))
        .filter((account) => account.enabled);
}
