import { resolveAgentWorkspaceDir, resolveDefaultAgentId } from "../agents/agent-scope.js";
import { resolveDefaultAgentWorkspaceDir } from "../agents/workspace.js";
import { loadConfig } from "../config/config.js";
import { createSubsystemLogger } from "../logging/subsystem.js";
import { loadOpenClawPlugins } from "./loader.js";
const log = createSubsystemLogger("plugins");
export function buildPluginStatusReport(params) {
    const config = params?.config ?? loadConfig();
    const workspaceDir = params?.workspaceDir
        ? params.workspaceDir
        : (resolveAgentWorkspaceDir(config, resolveDefaultAgentId(config)) ??
            resolveDefaultAgentWorkspaceDir());
    const registry = loadOpenClawPlugins({
        config,
        workspaceDir,
        logger: {
            info: (msg) => log.info(msg),
            warn: (msg) => log.warn(msg),
            error: (msg) => log.error(msg),
            debug: (msg) => log.debug(msg),
        },
    });
    return {
        workspaceDir,
        ...registry,
    };
}
