import { sendMessageDiscord, sendPollDiscord } from "../../../discord/send.js";
export const discordOutbound = {
    deliveryMode: "direct",
    chunker: null,
    textChunkLimit: 2000,
    pollMaxOptions: 10,
    resolveTarget: ({ to }) => {
        const trimmed = to?.trim();
        if (!trimmed) {
            return {
                ok: false,
                error: new Error("Delivering to Discord requires --to <channelId|user:ID|channel:ID>"),
            };
        }
        return { ok: true, to: trimmed };
    },
    sendText: async ({ to, text, accountId, deps, replyToId }) => {
        const send = deps?.sendDiscord ?? sendMessageDiscord;
        const result = await send(to, text, {
            verbose: false,
            replyTo: replyToId ?? undefined,
            accountId: accountId ?? undefined,
        });
        return { provider: "discord", ...result };
    },
    sendMedia: async ({ to, text, mediaUrl, accountId, deps, replyToId }) => {
        const send = deps?.sendDiscord ?? sendMessageDiscord;
        const result = await send(to, text, {
            verbose: false,
            mediaUrl,
            replyTo: replyToId ?? undefined,
            accountId: accountId ?? undefined,
        });
        return { provider: "discord", ...result };
    },
    sendPoll: async ({ to, poll, accountId }) => await sendPollDiscord(to, poll, {
        accountId: accountId ?? undefined,
    }),
};
