import { chunkMarkdownText } from "../../../auto-reply/chunk.js";
import { sendMessageTelegram } from "../../../telegram/send.js";
function parseReplyToMessageId(replyToId) {
    if (!replyToId)
        return undefined;
    const parsed = Number.parseInt(replyToId, 10);
    return Number.isFinite(parsed) ? parsed : undefined;
}
export const telegramOutbound = {
    deliveryMode: "direct",
    chunker: chunkMarkdownText,
    textChunkLimit: 4000,
    resolveTarget: ({ to }) => {
        const trimmed = to?.trim();
        if (!trimmed) {
            return {
                ok: false,
                error: new Error("Delivering to Telegram requires --to <chatId>"),
            };
        }
        return { ok: true, to: trimmed };
    },
    sendText: async ({ to, text, accountId, deps, replyToId, threadId }) => {
        const send = deps?.sendTelegram ?? sendMessageTelegram;
        const replyToMessageId = parseReplyToMessageId(replyToId);
        const result = await send(to, text, {
            verbose: false,
            messageThreadId: threadId ?? undefined,
            replyToMessageId,
            accountId: accountId ?? undefined,
        });
        return { provider: "telegram", ...result };
    },
    sendMedia: async ({ to, text, mediaUrl, accountId, deps, replyToId, threadId, }) => {
        const send = deps?.sendTelegram ?? sendMessageTelegram;
        const replyToMessageId = parseReplyToMessageId(replyToId);
        const result = await send(to, text, {
            verbose: false,
            mediaUrl,
            messageThreadId: threadId ?? undefined,
            replyToMessageId,
            accountId: accountId ?? undefined,
        });
        return { provider: "telegram", ...result };
    },
};
