import { buildMessagingTarget, ensureTargetId, requireTargetKind, } from "../channels/targets.js";
export function parseSlackTarget(raw, options = {}) {
    const trimmed = raw.trim();
    if (!trimmed)
        return undefined;
    const mentionMatch = trimmed.match(/^<@([A-Z0-9]+)>$/i);
    if (mentionMatch) {
        return buildMessagingTarget("user", mentionMatch[1], trimmed);
    }
    if (trimmed.startsWith("user:")) {
        const id = trimmed.slice("user:".length).trim();
        return id ? buildMessagingTarget("user", id, trimmed) : undefined;
    }
    if (trimmed.startsWith("channel:")) {
        const id = trimmed.slice("channel:".length).trim();
        return id ? buildMessagingTarget("channel", id, trimmed) : undefined;
    }
    if (trimmed.startsWith("slack:")) {
        const id = trimmed.slice("slack:".length).trim();
        return id ? buildMessagingTarget("user", id, trimmed) : undefined;
    }
    if (trimmed.startsWith("@")) {
        const candidate = trimmed.slice(1).trim();
        const id = ensureTargetId({
            candidate,
            pattern: /^[A-Z0-9]+$/i,
            errorMessage: "Slack DMs require a user id (use user:<id> or <@id>)",
        });
        return buildMessagingTarget("user", id, trimmed);
    }
    if (trimmed.startsWith("#")) {
        const candidate = trimmed.slice(1).trim();
        const id = ensureTargetId({
            candidate,
            pattern: /^[A-Z0-9]+$/i,
            errorMessage: "Slack channels require a channel id (use channel:<id>)",
        });
        return buildMessagingTarget("channel", id, trimmed);
    }
    if (options.defaultKind) {
        return buildMessagingTarget(options.defaultKind, trimmed, trimmed);
    }
    return buildMessagingTarget("channel", trimmed, trimmed);
}
export function resolveSlackChannelId(raw) {
    const target = parseSlackTarget(raw, { defaultKind: "channel" });
    return requireTargetKind({ platform: "Slack", target, kind: "channel" });
}
