/** A two-letter ISO 639-1 language code.
 * @see https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes
 * @see https://www.loc.gov/standards/iso639-2/php/code_list.php
 */
export type LanguageCode = typeof LanguageCodes[keyof typeof LanguageCodes];
/**
 * @see {@link LanguageCode}
 */
export declare const LanguageCodes: {
    readonly Abkhazian: "ab";
    readonly Afar: "aa";
    readonly Afrikaans: "af";
    readonly Akan: "ak";
    readonly Albanian: "sq";
    readonly Amharic: "am";
    readonly Arabic: "ar";
    readonly Aragonese: "an";
    readonly Armenian: "hy";
    readonly Assamese: "as";
    readonly Avaric: "av";
    readonly Avestan: "ae";
    readonly Aymara: "ay";
    readonly Azerbaijani: "az";
    readonly Bambara: "bm";
    readonly Bashkir: "ba";
    readonly Basque: "eu";
    readonly Belarusian: "be";
    readonly Bengali: "bn";
    readonly Bislama: "bi";
    readonly Bosnian: "bs";
    readonly Breton: "br";
    readonly Bulgarian: "bg";
    readonly Burmese: "my";
    readonly Catalan: "ca";
    readonly Chamorro: "ch";
    readonly Chechen: "ce";
    readonly Chichewa: "ny";
    readonly Chinese: "zh";
    readonly ChurchSlavonic: "cu";
    readonly Chuvash: "cv";
    readonly Cornish: "kw";
    readonly Corsican: "co";
    readonly Cree: "cr";
    readonly Croatian: "hr";
    readonly Czech: "cs";
    readonly Danish: "da";
    readonly Divehi: "dv";
    readonly Dutch: "nl";
    readonly Dzongkha: "dz";
    readonly English: "en";
    readonly Esperanto: "eo";
    readonly Estonian: "et";
    readonly Ewe: "ee";
    readonly Faroese: "fo";
    readonly Fijian: "fj";
    readonly Finnish: "fi";
    readonly French: "fr";
    readonly WesternFrisian: "fy";
    readonly Fulah: "ff";
    readonly Gaelic: "gd";
    readonly Galician: "gl";
    readonly Ganda: "lg";
    readonly Georgian: "ka";
    readonly German: "de";
    readonly Greek: "el";
    readonly Kalaallisut: "kl";
    readonly Guarani: "gn";
    readonly Gujarati: "gu";
    readonly Haitian: "ht";
    readonly Hausa: "ha";
    readonly Hebrew: "he";
    readonly Herero: "hz";
    readonly Hindi: "hi";
    readonly HiriMotu: "ho";
    readonly Hungarian: "hu";
    readonly Icelandic: "is";
    readonly Ido: "io";
    readonly Igbo: "ig";
    readonly Indonesian: "id";
    readonly Interlingua: "ia";
    readonly Interlingue: "ie";
    readonly Inuktitut: "iu";
    readonly Inupiaq: "ik";
    readonly Irish: "ga";
    readonly Italian: "it";
    readonly Japanese: "ja";
    readonly Javanese: "jv";
    readonly Kannada: "kn";
    readonly Kanuri: "kr";
    readonly Kashmiri: "ks";
    readonly Kazakh: "kk";
    readonly CentralKhmer: "km";
    readonly Kikuyu: "ki";
    readonly Kinyarwanda: "rw";
    readonly Kirghiz: "ky";
    readonly Komi: "kv";
    readonly Kongo: "kg";
    readonly Korean: "ko";
    readonly Kuanyama: "kj";
    readonly Kurdish: "ku";
    readonly Lao: "lo";
    readonly Latin: "la";
    readonly Latvian: "lv";
    readonly Limburgan: "li";
    readonly Lingala: "ln";
    readonly Lithuanian: "lt";
    readonly LubaKatanga: "lu";
    readonly Luxembourgish: "lb";
    readonly Macedonian: "mk";
    readonly Malagasy: "mg";
    readonly Malay: "ms";
    readonly Malayalam: "ml";
    readonly Maltese: "mt";
    readonly Manx: "gv";
    readonly Maori: "mi";
    readonly Marathi: "mr";
    readonly Marshallese: "mh";
    readonly Mongolian: "mn";
    readonly Nauru: "na";
    readonly Navajo: "nv";
    readonly NorthNdebele: "nd";
    readonly SouthNdebele: "nr";
    readonly Ndonga: "ng";
    readonly Nepali: "ne";
    readonly Norwegian: "no";
    readonly NorwegianBokmål: "nb";
    readonly NorwegianNynorsk: "nn";
    readonly SichuanYi: "ii";
    readonly Occitan: "oc";
    readonly Ojibwa: "oj";
    readonly Oriya: "or";
    readonly Oromo: "om";
    readonly Ossetian: "os";
    readonly Pali: "pi";
    readonly Pashto: "ps";
    readonly Persian: "fa";
    readonly Polish: "pl";
    readonly Portuguese: "pt";
    readonly Punjabi: "pa";
    readonly Quechua: "qu";
    readonly Romanian: "ro";
    readonly Romansh: "rm";
    readonly Rundi: "rn";
    readonly Russian: "ru";
    readonly NorthernSami: "se";
    readonly Samoan: "sm";
    readonly Sango: "sg";
    readonly Sanskrit: "sa";
    readonly Sardinian: "sc";
    readonly Serbian: "sr";
    readonly Shona: "sn";
    readonly Sindhi: "sd";
    readonly Sinhala: "si";
    readonly Slovak: "sk";
    readonly Slovenian: "sl";
    readonly Somali: "so";
    readonly SouthernSotho: "st";
    readonly Spanish: "es";
    readonly Sundanese: "su";
    readonly Swahili: "sw";
    readonly Swati: "ss";
    readonly Swedish: "sv";
    readonly Tagalog: "tl";
    readonly Tahitian: "ty";
    readonly Tajik: "tg";
    readonly Tamil: "ta";
    readonly Tatar: "tt";
    readonly Telugu: "te";
    readonly Thai: "th";
    readonly Tibetan: "bo";
    readonly Tigrinya: "ti";
    readonly Tonga: "to";
    readonly Tsonga: "ts";
    readonly Tswana: "tn";
    readonly Turkish: "tr";
    readonly Turkmen: "tk";
    readonly Twi: "tw";
    readonly Uighur: "ug";
    readonly Ukrainian: "uk";
    readonly Urdu: "ur";
    readonly Uzbek: "uz";
    readonly Venda: "ve";
    readonly Vietnamese: "vi";
    readonly Volapük: "vo";
    readonly Walloon: "wa";
    readonly Welsh: "cy";
    readonly Wolof: "wo";
    readonly Xhosa: "xh";
    readonly Yiddish: "yi";
    readonly Yoruba: "yo";
    readonly Zhuang: "za";
    readonly Zulu: "zu";
};
