import { inferred, type array } from "@ark/util";
import { type Constraint } from "../constraint.ts";
import type { NodeSchema, nodeOfKind, reducibleKindOf } from "../kinds.ts";
import { BaseNode, type GettableKeyOrNode, type KeyOrKeyNode, type NodeSelector } from "../node.ts";
import type { Predicate } from "../predicate.ts";
import type { Divisor } from "../refinements/divisor.ts";
import type { ExactLength } from "../refinements/exactLength.ts";
import type { Pattern } from "../refinements/pattern.ts";
import type { ExclusiveDateRangeSchema, ExclusiveNumericRangeSchema, InclusiveDateRangeSchema, InclusiveNumericRangeSchema, LimitSchemaValue, UnknownRangeSchema } from "../refinements/range.ts";
import type { BaseScope } from "../scope.ts";
import type { BaseNodeDeclaration, TypeMeta } from "../shared/declare.ts";
import { Disjoint } from "../shared/disjoint.ts";
import { type NodeKind, type RootKind, type UnknownAttachments, type kindRightOf } from "../shared/implement.ts";
import type { JsonSchema } from "../shared/jsonSchema.ts";
import type { StandardJSONSchemaV1, StandardSchemaV1 } from "../shared/standardSchema.ts";
import type { ToJsonSchema } from "../shared/toJsonSchema.ts";
import { arkKind } from "../shared/utils.ts";
import type { Prop } from "../structure/prop.ts";
import type { PropFlatMapper, UndeclaredKeyBehavior } from "../structure/structure.ts";
import type { Morph } from "./morph.ts";
import type { Union } from "./union.ts";
export interface InternalRootDeclaration extends BaseNodeDeclaration {
    kind: RootKind;
}
export declare abstract class BaseRoot<
/** @ts-ignore cast variance */
out d extends InternalRootDeclaration = InternalRootDeclaration> extends BaseNode<d> implements StandardSchemaV1, StandardJSONSchemaV1 {
    readonly [arkKind]: "root";
    readonly [inferred]: unknown;
    constructor(attachments: UnknownAttachments, $: BaseScope);
    get rawIn(): BaseRoot;
    get rawOut(): BaseRoot;
    get internal(): this;
    get "~standard"(): StandardSchemaV1.ArkTypeProps;
    as(): this;
    brand(name: string): this;
    readonly(): this;
    readonly branches: readonly nodeOfKind<Union.ChildKind>[];
    distribute<mapOut, reduceOut = mapOut[]>(mapBranch: (branch: nodeOfKind<Union.ChildKind>, i: number, branches: array<nodeOfKind<Union.ChildKind>>) => mapOut, reduceMapped?: (mappedBranches: mapOut[]) => reduceOut): reduceOut;
    abstract get defaultShortDescription(): string;
    get shortDescription(): string;
    toJsonSchema(opts?: ToJsonSchema.Options): JsonSchema;
    toJsonSchemaRecurse(ctx: ToJsonSchema.Context): JsonSchema;
    get alwaysExpandJsonSchema(): boolean;
    protected toResolvedJsonSchema(ctx: ToJsonSchema.Context): JsonSchema;
    protected abstract innerToJsonSchema(ctx: ToJsonSchema.Context): JsonSchema;
    intersect(r: unknown): BaseRoot | Disjoint;
    rawIntersect(r: BaseRoot): BaseRoot;
    toNeverIfDisjoint(): BaseRoot;
    and(r: unknown): BaseRoot;
    rawAnd(r: BaseRoot): BaseRoot;
    or(r: unknown): BaseRoot;
    rawOr(r: BaseRoot): BaseRoot;
    map(flatMapEntry: PropFlatMapper): BaseRoot;
    pick(...keys: KeyOrKeyNode[]): BaseRoot;
    omit(...keys: KeyOrKeyNode[]): BaseRoot;
    required(): BaseRoot;
    partial(): BaseRoot;
    private _keyof?;
    keyof(): BaseRoot;
    get props(): Prop.Node[];
    merge(r: unknown): BaseRoot;
    private applyStructuralOperation;
    get(...path: GettableKeyOrNode[]): BaseRoot;
    extract(r: unknown): BaseRoot;
    exclude(r: unknown): BaseRoot;
    array(): BaseRoot;
    overlaps(r: unknown): boolean;
    extends(r: unknown): boolean;
    ifExtends(r: unknown): BaseRoot | undefined;
    subsumes(r: unknown): boolean;
    configure(meta: TypeMeta.MappableInput, selector?: NodeSelector): this;
    describe(description: string, selector?: NodeSelector): this;
    optional(): [this, "?"];
    default(thunkableValue: unknown): [this, "=", unknown];
    from(input: unknown): unknown;
    protected _pipe(...morphs: Morph[]): BaseRoot;
    protected tryPipe(...morphs: Morph[]): BaseRoot;
    pipe: ((...morphs: Morph[]) => BaseRoot) & {
        try: (...morphs: Morph[]) => BaseRoot;
    };
    to(def: unknown): BaseRoot;
    private toNode;
    rawPipeOnce(morph: Morph): BaseRoot;
    narrow(predicate: Predicate): BaseRoot;
    constrain<kind extends Constraint.PrimitiveKind>(kind: kind, schema: NodeSchema<kind>): BaseRoot;
    constrainIn<kind extends Constraint.PrimitiveKind>(kind: kind, schema: NodeSchema<kind>): BaseRoot;
    constrainOut<kind extends Constraint.PrimitiveKind>(kind: kind, schema: NodeSchema<kind>): BaseRoot;
    private _constrain;
    onUndeclaredKey(cfg: UndeclaredKeyBehavior | UndeclaredKeyConfig): BaseRoot;
    hasEqualMorphs(r: BaseRoot): boolean;
    onDeepUndeclaredKey(behavior: UndeclaredKeyBehavior): BaseRoot;
    filter(predicate: Predicate): BaseRoot;
    divisibleBy(schema: Divisor.Schema): BaseRoot;
    matching(schema: Pattern.Schema): BaseRoot;
    atLeast(schema: InclusiveNumericRangeSchema): BaseRoot;
    atMost(schema: InclusiveNumericRangeSchema): BaseRoot;
    moreThan(schema: ExclusiveNumericRangeSchema): BaseRoot;
    lessThan(schema: ExclusiveNumericRangeSchema): BaseRoot;
    atLeastLength(schema: InclusiveNumericRangeSchema): BaseRoot;
    atMostLength(schema: InclusiveNumericRangeSchema): BaseRoot;
    moreThanLength(schema: ExclusiveNumericRangeSchema): BaseRoot;
    lessThanLength(schema: ExclusiveNumericRangeSchema): BaseRoot;
    exactlyLength(schema: ExactLength.Schema): BaseRoot;
    atOrAfter(schema: InclusiveDateRangeSchema): BaseRoot;
    atOrBefore(schema: InclusiveDateRangeSchema): BaseRoot;
    laterThan(schema: ExclusiveDateRangeSchema): BaseRoot;
    earlierThan(schema: ExclusiveDateRangeSchema): BaseRoot;
}
export type UndeclaredKeyConfig = {
    rule: UndeclaredKeyBehavior;
    deep?: boolean;
};
export declare const emptyBrandNameMessage = "Expected a non-empty brand name after #";
export type emptyBrandNameMessage = typeof emptyBrandNameMessage;
export declare const writeInvalidJsonSchemaTargetMessage: (target: string) => string;
export declare const exclusivizeRangeSchema: <schema extends UnknownRangeSchema>(schema: schema) => schema;
export type exclusivizeRangeSchema<schema extends UnknownRangeSchema> = schema extends LimitSchemaValue ? {
    rule: schema;
    exclusive: true;
} : schema;
export declare const typeOrTermExtends: (t: unknown, base: unknown) => boolean;
export type intersectRoot<l extends RootKind, r extends NodeKind> = [
    l,
    r
] extends [r, l] ? l : asymmetricIntersectionOf<l, r> | asymmetricIntersectionOf<r, l>;
type asymmetricIntersectionOf<l extends NodeKind, r extends NodeKind> = l extends unknown ? r extends kindRightOf<l> ? l | reducibleKindOf<l> : never : never;
export type schemaKindRightOf<kind extends RootKind> = Extract<kindRightOf<kind>, RootKind>;
export type schemaKindOrRightOf<kind extends RootKind> = kind | schemaKindRightOf<kind>;
export type StructuralOperationBranchResultByName = {
    keyof: Union.ChildNode;
    pick: Union.ChildNode;
    omit: Union.ChildNode;
    get: Union.ChildNode;
    map: Union.ChildNode;
    required: Union.ChildNode;
    partial: Union.ChildNode;
    merge: Union.ChildNode;
    props: array<Prop.Node>;
};
export type StructuralOperationName = keyof StructuralOperationBranchResultByName;
export declare const writeLiteralUnionEntriesMessage: (expression: string) => string;
export declare const writeNonStructuralOperandMessage: <operation extends StructuralOperationName, operand extends string>(operation: operation, operand: operand) => writeNonStructuralOperandMessage<operation, operand>;
export type writeNonStructuralOperandMessage<operation extends StructuralOperationName, operand extends string> = `${operation} operand must be an object (was ${operand})`;
export {};
