import { type Key } from "@ark/util";
import type { nodeOfKind } from "../kinds.ts";
import type { BaseNode } from "../node.ts";
import type { BoundKind } from "../refinements/kinds.ts";
import type { Domain } from "../roots/domain.ts";
import type { BaseRoot } from "../roots/root.ts";
import type { Prop } from "../structure/prop.ts";
export interface DisjointEntry<kind extends DisjointKind = DisjointKind> {
    kind: kind;
    l: OperandsByDisjointKind[kind];
    r: OperandsByDisjointKind[kind];
    path: Key[];
    optional: boolean;
}
type OperandsByDisjointKind = {
    domain: nodeOfKind<"domain"> | Domain.Enumerable;
    unit: nodeOfKind<"unit">;
    proto: nodeOfKind<"proto">;
    presence: BaseRoot;
    range: nodeOfKind<BoundKind>;
    assignability: BaseNode;
    union: readonly BaseRoot[];
};
export type DisjointEntryContext = {
    path?: Key[];
    optional?: true;
};
export declare class Disjoint extends Array<DisjointEntry> {
    static init<kind extends DisjointKind>(kind: kind, l: OperandsByDisjointKind[kind], r: OperandsByDisjointKind[kind], ctx?: DisjointEntryContext): Disjoint;
    add<kind extends DisjointKind>(kind: kind, l: OperandsByDisjointKind[kind], r: OperandsByDisjointKind[kind], ctx?: DisjointEntryContext): Disjoint;
    get summary(): string;
    describeReasons(): string;
    throw(): never;
    invert(): Disjoint;
    withPrefixKey(key: PropertyKey, kind: Prop.Kind): Disjoint;
    toNeverIfDisjoint(): BaseRoot;
}
export type DisjointKind = keyof OperandsByDisjointKind;
export declare const writeUnsatisfiableExpressionError: <expression extends string>(expression: expression) => writeUnsatisfiableExpressionError<expression>;
export type writeUnsatisfiableExpressionError<expression extends string> = `${expression} results in an unsatisfiable type`;
export {};
