import { type requireKeys } from "@ark/util";
import type { Morph } from "../roots/morph.ts";
import type { BaseRoot } from "../roots/root.ts";
import type { declareNode } from "../shared/declare.ts";
import { type nodeImplementationOf } from "../shared/implement.ts";
import { BaseProp, type Prop } from "./prop.ts";
export declare namespace Optional {
    interface Schema extends Prop.Schema {
        default?: unknown;
    }
    interface Inner extends Prop.Inner {
        default?: unknown;
    }
    type Declaration = declareNode<Prop.Declaration<"optional"> & {
        schema: Schema;
        normalizedSchema: Schema;
        inner: Inner;
    }>;
    type Node = OptionalNode;
    namespace Node {
        type withDefault = requireKeys<Node, "default" | "defaultValueMorph" | "defaultValueMorphRef">;
    }
}
export declare class OptionalNode extends BaseProp<"optional"> {
    constructor(...args: ConstructorParameters<typeof BaseProp>);
    get rawIn(): OptionalNode;
    get outProp(): Prop.Node;
    expression: string;
    defaultValueMorph: Morph | undefined;
    defaultValueMorphRef: string | undefined;
}
export declare const Optional: {
    implementation: nodeImplementationOf<{
        reducibleTo: "optional";
        errorContext: null;
        kind: "optional";
        prerequisite: object;
        intersectionIsOpen: true;
        childKind: import("../shared/implement.ts").RootKind;
        schema: Optional.Schema;
        normalizedSchema: Optional.Schema;
        inner: Optional.Inner;
    }>;
    Node: typeof OptionalNode;
};
export declare const computeDefaultValueMorph: (key: PropertyKey, value: BaseRoot, defaultInput: unknown) => Morph<any>;
export declare const assertDefaultValueAssignability: (node: BaseRoot, value: unknown, key: PropertyKey | null) => unknown;
export type writeUnassignableDefaultValueMessage<baseDef extends string, defaultValue extends string> = `Default value ${defaultValue} must be assignable to ${baseDef}`;
export declare const writeNonPrimitiveNonFunctionDefaultValueMessage: (key: PropertyKey | null) => string;
