/**
 * @public
 * @enum
 */
export declare const AsyncInvokeStatus: {
    readonly COMPLETED: "Completed";
    readonly FAILED: "Failed";
    readonly IN_PROGRESS: "InProgress";
};
/**
 * @public
 */
export type AsyncInvokeStatus = (typeof AsyncInvokeStatus)[keyof typeof AsyncInvokeStatus];
/**
 * @public
 * @enum
 */
export declare const SortAsyncInvocationBy: {
    readonly SUBMISSION_TIME: "SubmissionTime";
};
/**
 * @public
 */
export type SortAsyncInvocationBy = (typeof SortAsyncInvocationBy)[keyof typeof SortAsyncInvocationBy];
/**
 * @public
 * @enum
 */
export declare const SortOrder: {
    readonly ASCENDING: "Ascending";
    readonly DESCENDING: "Descending";
};
/**
 * @public
 */
export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder];
/**
 * @public
 * @enum
 */
export declare const GuardrailImageFormat: {
    readonly JPEG: "jpeg";
    readonly PNG: "png";
};
/**
 * @public
 */
export type GuardrailImageFormat = (typeof GuardrailImageFormat)[keyof typeof GuardrailImageFormat];
/**
 * @public
 * @enum
 */
export declare const GuardrailContentQualifier: {
    readonly GROUNDING_SOURCE: "grounding_source";
    readonly GUARD_CONTENT: "guard_content";
    readonly QUERY: "query";
};
/**
 * @public
 */
export type GuardrailContentQualifier = (typeof GuardrailContentQualifier)[keyof typeof GuardrailContentQualifier];
/**
 * @public
 * @enum
 */
export declare const GuardrailOutputScope: {
    readonly FULL: "FULL";
    readonly INTERVENTIONS: "INTERVENTIONS";
};
/**
 * @public
 */
export type GuardrailOutputScope = (typeof GuardrailOutputScope)[keyof typeof GuardrailOutputScope];
/**
 * @public
 * @enum
 */
export declare const GuardrailContentSource: {
    readonly INPUT: "INPUT";
    readonly OUTPUT: "OUTPUT";
};
/**
 * @public
 */
export type GuardrailContentSource = (typeof GuardrailContentSource)[keyof typeof GuardrailContentSource];
/**
 * @public
 * @enum
 */
export declare const GuardrailAction: {
    readonly GUARDRAIL_INTERVENED: "GUARDRAIL_INTERVENED";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailAction = (typeof GuardrailAction)[keyof typeof GuardrailAction];
/**
 * @public
 * @enum
 */
export declare const GuardrailOrigin: {
    readonly ACCOUNT_ENFORCED: "ACCOUNT_ENFORCED";
    readonly ORGANIZATION_ENFORCED: "ORGANIZATION_ENFORCED";
    readonly REQUEST: "REQUEST";
};
/**
 * @public
 */
export type GuardrailOrigin = (typeof GuardrailOrigin)[keyof typeof GuardrailOrigin];
/**
 * @public
 * @enum
 */
export declare const GuardrailOwnership: {
    readonly CROSS_ACCOUNT: "CROSS_ACCOUNT";
    readonly SELF: "SELF";
};
/**
 * @public
 */
export type GuardrailOwnership = (typeof GuardrailOwnership)[keyof typeof GuardrailOwnership];
/**
 * @public
 * @enum
 */
export declare const GuardrailAutomatedReasoningLogicWarningType: {
    readonly ALWAYS_FALSE: "ALWAYS_FALSE";
    readonly ALWAYS_TRUE: "ALWAYS_TRUE";
};
/**
 * @public
 */
export type GuardrailAutomatedReasoningLogicWarningType = (typeof GuardrailAutomatedReasoningLogicWarningType)[keyof typeof GuardrailAutomatedReasoningLogicWarningType];
/**
 * @public
 * @enum
 */
export declare const GuardrailContentPolicyAction: {
    readonly BLOCKED: "BLOCKED";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailContentPolicyAction = (typeof GuardrailContentPolicyAction)[keyof typeof GuardrailContentPolicyAction];
/**
 * @public
 * @enum
 */
export declare const GuardrailContentFilterConfidence: {
    readonly HIGH: "HIGH";
    readonly LOW: "LOW";
    readonly MEDIUM: "MEDIUM";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailContentFilterConfidence = (typeof GuardrailContentFilterConfidence)[keyof typeof GuardrailContentFilterConfidence];
/**
 * @public
 * @enum
 */
export declare const GuardrailContentFilterStrength: {
    readonly HIGH: "HIGH";
    readonly LOW: "LOW";
    readonly MEDIUM: "MEDIUM";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailContentFilterStrength = (typeof GuardrailContentFilterStrength)[keyof typeof GuardrailContentFilterStrength];
/**
 * @public
 * @enum
 */
export declare const GuardrailContentFilterType: {
    readonly HATE: "HATE";
    readonly INSULTS: "INSULTS";
    readonly MISCONDUCT: "MISCONDUCT";
    readonly PROMPT_ATTACK: "PROMPT_ATTACK";
    readonly SEXUAL: "SEXUAL";
    readonly VIOLENCE: "VIOLENCE";
};
/**
 * @public
 */
export type GuardrailContentFilterType = (typeof GuardrailContentFilterType)[keyof typeof GuardrailContentFilterType];
/**
 * @public
 * @enum
 */
export declare const GuardrailContextualGroundingPolicyAction: {
    readonly BLOCKED: "BLOCKED";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailContextualGroundingPolicyAction = (typeof GuardrailContextualGroundingPolicyAction)[keyof typeof GuardrailContextualGroundingPolicyAction];
/**
 * @public
 * @enum
 */
export declare const GuardrailContextualGroundingFilterType: {
    readonly GROUNDING: "GROUNDING";
    readonly RELEVANCE: "RELEVANCE";
};
/**
 * @public
 */
export type GuardrailContextualGroundingFilterType = (typeof GuardrailContextualGroundingFilterType)[keyof typeof GuardrailContextualGroundingFilterType];
/**
 * @public
 * @enum
 */
export declare const GuardrailSensitiveInformationPolicyAction: {
    readonly ANONYMIZED: "ANONYMIZED";
    readonly BLOCKED: "BLOCKED";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailSensitiveInformationPolicyAction = (typeof GuardrailSensitiveInformationPolicyAction)[keyof typeof GuardrailSensitiveInformationPolicyAction];
/**
 * @public
 * @enum
 */
export declare const GuardrailPiiEntityType: {
    readonly ADDRESS: "ADDRESS";
    readonly AGE: "AGE";
    readonly AWS_ACCESS_KEY: "AWS_ACCESS_KEY";
    readonly AWS_SECRET_KEY: "AWS_SECRET_KEY";
    readonly CA_HEALTH_NUMBER: "CA_HEALTH_NUMBER";
    readonly CA_SOCIAL_INSURANCE_NUMBER: "CA_SOCIAL_INSURANCE_NUMBER";
    readonly CREDIT_DEBIT_CARD_CVV: "CREDIT_DEBIT_CARD_CVV";
    readonly CREDIT_DEBIT_CARD_EXPIRY: "CREDIT_DEBIT_CARD_EXPIRY";
    readonly CREDIT_DEBIT_CARD_NUMBER: "CREDIT_DEBIT_CARD_NUMBER";
    readonly DRIVER_ID: "DRIVER_ID";
    readonly EMAIL: "EMAIL";
    readonly INTERNATIONAL_BANK_ACCOUNT_NUMBER: "INTERNATIONAL_BANK_ACCOUNT_NUMBER";
    readonly IP_ADDRESS: "IP_ADDRESS";
    readonly LICENSE_PLATE: "LICENSE_PLATE";
    readonly MAC_ADDRESS: "MAC_ADDRESS";
    readonly NAME: "NAME";
    readonly PASSWORD: "PASSWORD";
    readonly PHONE: "PHONE";
    readonly PIN: "PIN";
    readonly SWIFT_CODE: "SWIFT_CODE";
    readonly UK_NATIONAL_HEALTH_SERVICE_NUMBER: "UK_NATIONAL_HEALTH_SERVICE_NUMBER";
    readonly UK_NATIONAL_INSURANCE_NUMBER: "UK_NATIONAL_INSURANCE_NUMBER";
    readonly UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER: "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER";
    readonly URL: "URL";
    readonly USERNAME: "USERNAME";
    readonly US_BANK_ACCOUNT_NUMBER: "US_BANK_ACCOUNT_NUMBER";
    readonly US_BANK_ROUTING_NUMBER: "US_BANK_ROUTING_NUMBER";
    readonly US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER: "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER";
    readonly US_PASSPORT_NUMBER: "US_PASSPORT_NUMBER";
    readonly US_SOCIAL_SECURITY_NUMBER: "US_SOCIAL_SECURITY_NUMBER";
    readonly VEHICLE_IDENTIFICATION_NUMBER: "VEHICLE_IDENTIFICATION_NUMBER";
};
/**
 * @public
 */
export type GuardrailPiiEntityType = (typeof GuardrailPiiEntityType)[keyof typeof GuardrailPiiEntityType];
/**
 * @public
 * @enum
 */
export declare const GuardrailTopicPolicyAction: {
    readonly BLOCKED: "BLOCKED";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailTopicPolicyAction = (typeof GuardrailTopicPolicyAction)[keyof typeof GuardrailTopicPolicyAction];
/**
 * @public
 * @enum
 */
export declare const GuardrailTopicType: {
    readonly DENY: "DENY";
};
/**
 * @public
 */
export type GuardrailTopicType = (typeof GuardrailTopicType)[keyof typeof GuardrailTopicType];
/**
 * @public
 * @enum
 */
export declare const GuardrailWordPolicyAction: {
    readonly BLOCKED: "BLOCKED";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type GuardrailWordPolicyAction = (typeof GuardrailWordPolicyAction)[keyof typeof GuardrailWordPolicyAction];
/**
 * @public
 * @enum
 */
export declare const GuardrailManagedWordType: {
    readonly PROFANITY: "PROFANITY";
};
/**
 * @public
 */
export type GuardrailManagedWordType = (typeof GuardrailManagedWordType)[keyof typeof GuardrailManagedWordType];
/**
 * @public
 * @enum
 */
export declare const GuardrailTrace: {
    readonly DISABLED: "disabled";
    readonly ENABLED: "enabled";
    readonly ENABLED_FULL: "enabled_full";
};
/**
 * @public
 */
export type GuardrailTrace = (typeof GuardrailTrace)[keyof typeof GuardrailTrace];
/**
 * @public
 * @enum
 */
export declare const AudioFormat: {
    readonly AAC: "aac";
    readonly FLAC: "flac";
    readonly M4A: "m4a";
    readonly MKA: "mka";
    readonly MKV: "mkv";
    readonly MP3: "mp3";
    readonly MP4: "mp4";
    readonly MPEG: "mpeg";
    readonly MPGA: "mpga";
    readonly OGG: "ogg";
    readonly OPUS: "opus";
    readonly PCM: "pcm";
    readonly WAV: "wav";
    readonly WEBM: "webm";
    readonly X_AAC: "x-aac";
};
/**
 * @public
 */
export type AudioFormat = (typeof AudioFormat)[keyof typeof AudioFormat];
/**
 * @public
 * @enum
 */
export declare const CacheTTL: {
    readonly FIVE_MINUTES: "5m";
    readonly ONE_HOUR: "1h";
};
/**
 * @public
 */
export type CacheTTL = (typeof CacheTTL)[keyof typeof CacheTTL];
/**
 * @public
 * @enum
 */
export declare const CachePointType: {
    readonly DEFAULT: "default";
};
/**
 * @public
 */
export type CachePointType = (typeof CachePointType)[keyof typeof CachePointType];
/**
 * @public
 * @enum
 */
export declare const DocumentFormat: {
    readonly CSV: "csv";
    readonly DOC: "doc";
    readonly DOCX: "docx";
    readonly HTML: "html";
    readonly MD: "md";
    readonly PDF: "pdf";
    readonly TXT: "txt";
    readonly XLS: "xls";
    readonly XLSX: "xlsx";
};
/**
 * @public
 */
export type DocumentFormat = (typeof DocumentFormat)[keyof typeof DocumentFormat];
/**
 * @public
 * @enum
 */
export declare const GuardrailConverseImageFormat: {
    readonly JPEG: "jpeg";
    readonly PNG: "png";
};
/**
 * @public
 */
export type GuardrailConverseImageFormat = (typeof GuardrailConverseImageFormat)[keyof typeof GuardrailConverseImageFormat];
/**
 * @public
 * @enum
 */
export declare const GuardrailConverseContentQualifier: {
    readonly GROUNDING_SOURCE: "grounding_source";
    readonly GUARD_CONTENT: "guard_content";
    readonly QUERY: "query";
};
/**
 * @public
 */
export type GuardrailConverseContentQualifier = (typeof GuardrailConverseContentQualifier)[keyof typeof GuardrailConverseContentQualifier];
/**
 * @public
 * @enum
 */
export declare const ImageFormat: {
    readonly GIF: "gif";
    readonly JPEG: "jpeg";
    readonly PNG: "png";
    readonly WEBP: "webp";
};
/**
 * @public
 */
export type ImageFormat = (typeof ImageFormat)[keyof typeof ImageFormat];
/**
 * @public
 * @enum
 */
export declare const VideoFormat: {
    readonly FLV: "flv";
    readonly MKV: "mkv";
    readonly MOV: "mov";
    readonly MP4: "mp4";
    readonly MPEG: "mpeg";
    readonly MPG: "mpg";
    readonly THREE_GP: "three_gp";
    readonly WEBM: "webm";
    readonly WMV: "wmv";
};
/**
 * @public
 */
export type VideoFormat = (typeof VideoFormat)[keyof typeof VideoFormat];
/**
 * @public
 * @enum
 */
export declare const ToolResultStatus: {
    readonly ERROR: "error";
    readonly SUCCESS: "success";
};
/**
 * @public
 */
export type ToolResultStatus = (typeof ToolResultStatus)[keyof typeof ToolResultStatus];
/**
 * @public
 * @enum
 */
export declare const ToolUseType: {
    readonly SERVER_TOOL_USE: "server_tool_use";
};
/**
 * @public
 */
export type ToolUseType = (typeof ToolUseType)[keyof typeof ToolUseType];
/**
 * @public
 * @enum
 */
export declare const ConversationRole: {
    readonly ASSISTANT: "assistant";
    readonly USER: "user";
};
/**
 * @public
 */
export type ConversationRole = (typeof ConversationRole)[keyof typeof ConversationRole];
/**
 * @public
 * @enum
 */
export declare const PerformanceConfigLatency: {
    readonly OPTIMIZED: "optimized";
    readonly STANDARD: "standard";
};
/**
 * @public
 */
export type PerformanceConfigLatency = (typeof PerformanceConfigLatency)[keyof typeof PerformanceConfigLatency];
/**
 * @public
 * @enum
 */
export declare const ServiceTierType: {
    readonly DEFAULT: "default";
    readonly FLEX: "flex";
    readonly PRIORITY: "priority";
    readonly RESERVED: "reserved";
};
/**
 * @public
 */
export type ServiceTierType = (typeof ServiceTierType)[keyof typeof ServiceTierType];
/**
 * @public
 * @enum
 */
export declare const StopReason: {
    readonly CONTENT_FILTERED: "content_filtered";
    readonly END_TURN: "end_turn";
    readonly GUARDRAIL_INTERVENED: "guardrail_intervened";
    readonly MALFORMED_MODEL_OUTPUT: "malformed_model_output";
    readonly MALFORMED_TOOL_USE: "malformed_tool_use";
    readonly MAX_TOKENS: "max_tokens";
    readonly MODEL_CONTEXT_WINDOW_EXCEEDED: "model_context_window_exceeded";
    readonly STOP_SEQUENCE: "stop_sequence";
    readonly TOOL_USE: "tool_use";
};
/**
 * @public
 */
export type StopReason = (typeof StopReason)[keyof typeof StopReason];
/**
 * @public
 * @enum
 */
export declare const GuardrailStreamProcessingMode: {
    readonly ASYNC: "async";
    readonly SYNC: "sync";
};
/**
 * @public
 */
export type GuardrailStreamProcessingMode = (typeof GuardrailStreamProcessingMode)[keyof typeof GuardrailStreamProcessingMode];
/**
 * @public
 * @enum
 */
export declare const Trace: {
    readonly DISABLED: "DISABLED";
    readonly ENABLED: "ENABLED";
    readonly ENABLED_FULL: "ENABLED_FULL";
};
/**
 * @public
 */
export type Trace = (typeof Trace)[keyof typeof Trace];
