/*
   Copyright 2024 Misha Kaletsky

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.


                                 Apache License
                           Version 2.0, January 2004
                        http://www.apache.org/licenses/

   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

   1. Definitions.

      "License" shall mean the terms and conditions for use, reproduction,
      and distribution as defined by Sections 1 through 9 of this document.

      "Licensor" shall mean the copyright owner or entity authorized by
      the copyright owner that is granting the License.

      "Legal Entity" shall mean the union of the acting entity and all
      other entities that control, are controlled by, or are under common
      control with that entity. For the purposes of this definition,
      "control" means (i) the power, direct or indirect, to cause the
      direction or management of such entity, whether by contract or
      otherwise, or (ii) ownership of fifty percent (50%) or more of the
      outstanding shares, or (iii) beneficial ownership of such entity.

      "You" (or "Your") shall mean an individual or Legal Entity
      exercising permissions granted by this License.

      "Source" form shall mean the preferred form for making modifications,
      including but not limited to software source code, documentation
      source, and configuration files.

      "Object" form shall mean any form resulting from mechanical
      transformation or translation of a Source form, including but
      not limited to compiled object code, generated documentation,
      and conversions to other media types.

      "Work" shall mean the work of authorship, whether in Source or
      Object form, made available under the License, as indicated by a
      copyright notice that is included in or attached to the work
      (an example is provided in the Appendix below).

      "Derivative Works" shall mean any work, whether in Source or Object
      form, that is based on (or derived from) the Work and for which the
      editorial revisions, annotations, elaborations, or other modifications
      represent, as a whole, an original work of authorship. For the purposes
      of this License, Derivative Works shall not include works that remain
      separable from, or merely link (or bind by name) to the interfaces of,
      the Work and Derivative Works thereof.

      "Contribution" shall mean any work of authorship, including
      the original version of the Work and any modifications or additions
      to that Work or Derivative Works thereof, that is intentionally
      submitted to Licensor for inclusion in the Work by the copyright owner
      or by an individual or Legal Entity authorized to submit on behalf of
      the copyright owner. For the purposes of this definition, "submitted"
      means any form of electronic, verbal, or written communication sent
      to the Licensor or its representatives, including but not limited to
      communication on electronic mailing lists, source code control systems,
      and issue tracking systems that are managed by, or on behalf of, the
      Licensor for the purpose of discussing and improving the Work, but
      excluding communication that is conspicuously marked or otherwise
      designated in writing by the copyright owner as "Not a Contribution."

      "Contributor" shall mean Licensor and any individual or Legal Entity
      on behalf of whom a Contribution has been received by Licensor and
      subsequently incorporated within the Work.

   2. Grant of Copyright License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      copyright license to reproduce, prepare Derivative Works of,
      publicly display, publicly perform, sublicense, and distribute the
      Work and such Derivative Works in Source or Object form.

   3. Grant of Patent License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      (except as stated in this section) patent license to make, have made,
      use, offer to sell, sell, import, and otherwise transfer the Work,
      where such license applies only to those patent claims licensable
      by such Contributor that are necessarily infringed by their
      Contribution(s) alone or by combination of their Contribution(s)
      with the Work to which such Contribution(s) was submitted. If You
      institute patent litigation against any entity (including a
      cross-claim or counterclaim in a lawsuit) alleging that the Work
      or a Contribution incorporated within the Work constitutes direct
      or contributory patent infringement, then any patent licenses
      granted to You under this License for that Work shall terminate
      as of the date such litigation is filed.

   4. Redistribution. You may reproduce and distribute copies of the
      Work or Derivative Works thereof in any medium, with or without
      modifications, and in Source or Object form, provided that You
      meet the following conditions:

      (a) You must give any other recipients of the Work or
          Derivative Works a copy of this License; and

      (b) You must cause any modified files to carry prominent notices
          stating that You changed the files; and

      (c) You must retain, in the Source form of any Derivative Works
          that You distribute, all copyright, patent, trademark, and
          attribution notices from the Source form of the Work,
          excluding those notices that do not pertain to any part of
          the Derivative Works; and

      (d) If the Work includes a "NOTICE" text file as part of its
          distribution, then any Derivative Works that You distribute must
          include a readable copy of the attribution notices contained
          within such NOTICE file, excluding those notices that do not
          pertain to any part of the Derivative Works, in at least one
          of the following places: within a NOTICE text file distributed
          as part of the Derivative Works; within the Source form or
          documentation, if provided along with the Derivative Works; or,
          within a display generated by the Derivative Works, if and
          wherever such third-party notices normally appear. The contents
          of the NOTICE file are for informational purposes only and
          do not modify the License. You may add Your own attribution
          notices within Derivative Works that You distribute, alongside
          or as an addendum to the NOTICE text from the Work, provided
          that such additional attribution notices cannot be construed
          as modifying the License.

      You may add Your own copyright statement to Your modifications and
      may provide additional or different license terms and conditions
      for use, reproduction, or distribution of Your modifications, or
      for any such Derivative Works as a whole, provided Your use,
      reproduction, and distribution of the Work otherwise complies with
      the conditions stated in this License.

   5. Submission of Contributions. Unless You explicitly state otherwise,
      any Contribution intentionally submitted for inclusion in the Work
      by You to the Licensor shall be under the terms and conditions of
      this License, without any additional terms or conditions.
      Notwithstanding the above, nothing herein shall supersede or modify
      the terms of any separate license agreement you may have executed
      with Licensor regarding such Contributions.

   6. Trademarks. This License does not grant permission to use the trade
      names, trademarks, service marks, or product names of the Licensor,
      except as required for reasonable and customary use in describing the
      origin of the Work and reproducing the content of the NOTICE file.

   7. Disclaimer of Warranty. Unless required by applicable law or
      agreed to in writing, Licensor provides the Work (and each
      Contributor provides its Contributions) on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
      implied, including, without limitation, any warranties or conditions
      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
      PARTICULAR PURPOSE. You are solely responsible for determining the
      appropriateness of using or redistributing the Work and assume any
      risks associated with Your exercise of permissions under this License.

   8. Limitation of Liability. In no event and under no legal theory,
      whether in tort (including negligence), contract, or otherwise,
      unless required by applicable law (such as deliberate and grossly
      negligent acts) or agreed to in writing, shall any Contributor be
      liable to You for damages, including any direct, indirect, special,
      incidental, or consequential damages of any character arising as a
      result of this License or out of the use or inability to use the
      Work (including but not limited to damages for loss of goodwill,
      work stoppage, computer failure or malfunction, or any and all
      other commercial damages or losses), even if such Contributor
      has been advised of the possibility of such damages.

   9. Accepting Warranty or Additional Liability. While redistributing
      the Work or Derivative Works thereof, You may choose to offer,
      and charge a fee for, acceptance of support, warranty, indemnity,
      or other liability obligations and/or rights consistent with this
      License. However, in accepting such obligations, You may act only
      on Your own behalf and on Your sole responsibility, not on behalf
      of any other Contributor, and only if You agree to indemnify,
      defend, and hold each Contributor harmless for any liability
      incurred by, or claims asserted against, such Contributor by reason
      of your accepting any such warranty or additional liability.

   END OF TERMS AND CONDITIONS
*/

import type {
  IsNever,
  StrictEqualUsingTSInternalIdenticalToOperator,
  UnionToIntersection,
  UnionToTuple,
} from "./utils";
/**
 * The simple(ish) way to get overload info from a function
 * {@linkcode FunctionType}. Recent versions of TypeScript will match any
 * function against a generic 10-overload type, filling in slots with
 * duplicates of the function. So, we can just match against a single type
 * and get all the overloads.
 *
 * For older versions of TypeScript, we'll need to painstakingly do
 * ten separate matches.
 */
export type TSPost53OverloadsInfoUnion<FunctionType> = FunctionType extends {
  (...args: infer A1): infer R1;
  (...args: infer A2): infer R2;
  (...args: infer A3): infer R3;
  (...args: infer A4): infer R4;
  (...args: infer A5): infer R5;
  (...args: infer A6): infer R6;
  (...args: infer A7): infer R7;
  (...args: infer A8): infer R8;
  (...args: infer A9): infer R9;
  (...args: infer A10): infer R10;
}
  ?
      | ((...p: A1) => R1)
      | ((...p: A2) => R2)
      | ((...p: A3) => R3)
      | ((...p: A4) => R4)
      | ((...p: A5) => R5)
      | ((...p: A6) => R6)
      | ((...p: A7) => R7)
      | ((...p: A8) => R8)
      | ((...p: A9) => R9)
      | ((...p: A10) => R10)
  : never;
/**
 * A function with `unknown` parameters and return type.
 */
export type UnknownFunction = (...args: unknown[]) => unknown;
/**
 * `true` iff {@linkcode FunctionType} is
 * equivalent to `(...args: unknown[]) => unknown`,
 * which is what an overload variant looks like for a non-existent overload.
 * This is useful because older versions of TypeScript end up with
 * 9 "useless" overloads and one real one for parameterless/generic functions.
 *
 * @see {@link https://github.com/microsoft/TypeScript/issues/28867 | Related}
 */
export type IsUselessOverloadInfo<FunctionType> = StrictEqualUsingTSInternalIdenticalToOperator<
  FunctionType,
  UnknownFunction
>;
/**
 * Old versions of TypeScript can sometimes seem to refuse to separate out
 * union members unless you put them each in a pointless tuple and add an
 * extra `infer X` expression. There may be a better way to work around this
 * problem, but since it's not a problem in newer versions of TypeScript,
 * it's not a priority right now.
 */
export type Tuplify<Union> = Union extends infer X ? [X] : never;
/**
 * For older versions of TypeScript, we need two separate workarounds
 * to get overload info. First, we need need to use
 * {@linkcode DecreasingOverloadsInfoUnion} to get the overload info for
 * functions with 1-10 overloads. Then, we need to filter out the
 * "useless" overloads that are present in older versions of TypeScript,
 * for parameterless functions. To do this we use
 * {@linkcode IsUselessOverloadInfo} to remove useless overloads.
 *
 * @see {@link https://github.com/microsoft/TypeScript/issues/28867 | Related}
 */
export type TSPre53OverloadsInfoUnion<FunctionType> =
  Tuplify<DecreasingOverloadsInfoUnion<FunctionType>> extends infer Tup
    ? Tup extends [infer Fn]
      ? IsUselessOverloadInfo<Fn> extends true
        ? never
        : Fn
      : never
    : never;
/**
 * For versions of TypeScript below 5.3, we need to check for 10 overloads,
 * then 9, then 8, etc., to get a union of the overload variants.
 */
export type DecreasingOverloadsInfoUnion<F> = F extends {
  (...args: infer A1): infer R1;
  (...args: infer A2): infer R2;
  (...args: infer A3): infer R3;
  (...args: infer A4): infer R4;
  (...args: infer A5): infer R5;
  (...args: infer A6): infer R6;
  (...args: infer A7): infer R7;
  (...args: infer A8): infer R8;
  (...args: infer A9): infer R9;
  (...args: infer A10): infer R10;
}
  ?
      | ((...p: A1) => R1)
      | ((...p: A2) => R2)
      | ((...p: A3) => R3)
      | ((...p: A4) => R4)
      | ((...p: A5) => R5)
      | ((...p: A6) => R6)
      | ((...p: A7) => R7)
      | ((...p: A8) => R8)
      | ((...p: A9) => R9)
      | ((...p: A10) => R10)
  : F extends {
        (...args: infer A1): infer R1;
        (...args: infer A2): infer R2;
        (...args: infer A3): infer R3;
        (...args: infer A4): infer R4;
        (...args: infer A5): infer R5;
        (...args: infer A6): infer R6;
        (...args: infer A7): infer R7;
        (...args: infer A8): infer R8;
        (...args: infer A9): infer R9;
      }
    ?
        | ((...p: A1) => R1)
        | ((...p: A2) => R2)
        | ((...p: A3) => R3)
        | ((...p: A4) => R4)
        | ((...p: A5) => R5)
        | ((...p: A6) => R6)
        | ((...p: A7) => R7)
        | ((...p: A8) => R8)
        | ((...p: A9) => R9)
    : F extends {
          (...args: infer A1): infer R1;
          (...args: infer A2): infer R2;
          (...args: infer A3): infer R3;
          (...args: infer A4): infer R4;
          (...args: infer A5): infer R5;
          (...args: infer A6): infer R6;
          (...args: infer A7): infer R7;
          (...args: infer A8): infer R8;
        }
      ?
          | ((...p: A1) => R1)
          | ((...p: A2) => R2)
          | ((...p: A3) => R3)
          | ((...p: A4) => R4)
          | ((...p: A5) => R5)
          | ((...p: A6) => R6)
          | ((...p: A7) => R7)
          | ((...p: A8) => R8)
      : F extends {
            (...args: infer A1): infer R1;
            (...args: infer A2): infer R2;
            (...args: infer A3): infer R3;
            (...args: infer A4): infer R4;
            (...args: infer A5): infer R5;
            (...args: infer A6): infer R6;
            (...args: infer A7): infer R7;
          }
        ?
            | ((...p: A1) => R1)
            | ((...p: A2) => R2)
            | ((...p: A3) => R3)
            | ((...p: A4) => R4)
            | ((...p: A5) => R5)
            | ((...p: A6) => R6)
            | ((...p: A7) => R7)
        : F extends {
              (...args: infer A1): infer R1;
              (...args: infer A2): infer R2;
              (...args: infer A3): infer R3;
              (...args: infer A4): infer R4;
              (...args: infer A5): infer R5;
              (...args: infer A6): infer R6;
            }
          ?
              | ((...p: A1) => R1)
              | ((...p: A2) => R2)
              | ((...p: A3) => R3)
              | ((...p: A4) => R4)
              | ((...p: A5) => R5)
              | ((...p: A6) => R6)
          : F extends {
                (...args: infer A1): infer R1;
                (...args: infer A2): infer R2;
                (...args: infer A3): infer R3;
                (...args: infer A4): infer R4;
                (...args: infer A5): infer R5;
              }
            ? ((...p: A1) => R1) | ((...p: A2) => R2) | ((...p: A3) => R3) | ((...p: A4) => R4) | ((...p: A5) => R5)
            : F extends {
                  (...args: infer A1): infer R1;
                  (...args: infer A2): infer R2;
                  (...args: infer A3): infer R3;
                  (...args: infer A4): infer R4;
                }
              ? ((...p: A1) => R1) | ((...p: A2) => R2) | ((...p: A3) => R3) | ((...p: A4) => R4)
              : F extends {
                    (...args: infer A1): infer R1;
                    (...args: infer A2): infer R2;
                    (...args: infer A3): infer R3;
                  }
                ? ((...p: A1) => R1) | ((...p: A2) => R2) | ((...p: A3) => R3)
                : F extends {
                      (...args: infer A1): infer R1;
                      (...args: infer A2): infer R2;
                    }
                  ? ((...p: A1) => R1) | ((...p: A2) => R2)
                  : F extends (...args: infer A1) => infer R1
                    ? (...p: A1) => R1
                    : never;
/**
 * Get a union of overload variants for a function {@linkcode FunctionType}.
 * Does a check for whether we can do the one-shot
 * 10-overload matcher (which works for ts\>5.3), and if not,
 * falls back to the more complicated utility.
 */
export type OverloadsInfoUnion<FunctionType> =
  IsNever<TSPost53OverloadsInfoUnion<(a: 1) => 2>> extends true
    ? TSPre53OverloadsInfoUnion<FunctionType>
    : TSPost53OverloadsInfoUnion<FunctionType>;
/**
 * Allows inferring any function using the `infer` keyword.
 */
export type InferFunctionType<FunctionType extends (...args: any) => any> = FunctionType;
/**
 * A union type of the parameters allowed for any
 * overload of function {@linkcode FunctionType}.
 */
export type OverloadParameters<FunctionType> =
  OverloadsInfoUnion<FunctionType> extends InferFunctionType<infer Fn> ? Parameters<Fn> : never;
/**
 * A union type of the return types for any overload of
 * function {@linkcode FunctionType}.
 */
export type OverloadReturnTypes<FunctionType> =
  OverloadsInfoUnion<FunctionType> extends InferFunctionType<infer Fn> ? ReturnType<Fn> : never;
/**
 * Takes an overload variants {@linkcode Union},
 * produced from {@linkcode OverloadsInfoUnion} and rejects
 * the ones incompatible with parameters {@linkcode Args}.
 */
export type SelectOverloadsInfo<Union extends UnknownFunction, Args extends unknown[]> =
  Union extends InferFunctionType<infer Fn> ? (Args extends Parameters<Fn> ? Fn : never) : never;
/**
 * Creates a new overload (an intersection type) from an existing one,
 * which only includes variant(s) which can accept
 * {@linkcode Args} as parameters.
 */
export type OverloadsNarrowedByParameters<
  FunctionType,
  Args extends OverloadParameters<FunctionType>,
> = UnionToIntersection<SelectOverloadsInfo<OverloadsInfoUnion<FunctionType>, Args>>;
/**
 * The simple(ish) way to get overload info from a constructor
 * {@linkcode ConstructorType}. Recent versions of TypeScript will match any
 * constructor against a generic 10-overload type, filling in slots with
 * duplicates of the constructor. So, we can just match against a single type
 * and get all the overloads.
 *
 * For older versions of TypeScript,
 * we'll need to painstakingly do ten separate matches.
 */
export type TSPost53ConstructorOverloadsInfoUnion<ConstructorType> = ConstructorType extends {
  new (...args: infer A1): infer R1;
  new (...args: infer A2): infer R2;
  new (...args: infer A3): infer R3;
  new (...args: infer A4): infer R4;
  new (...args: infer A5): infer R5;
  new (...args: infer A6): infer R6;
  new (...args: infer A7): infer R7;
  new (...args: infer A8): infer R8;
  new (...args: infer A9): infer R9;
  new (...args: infer A10): infer R10;
}
  ?
      | (new (...p: A1) => R1)
      | (new (...p: A2) => R2)
      | (new (...p: A3) => R3)
      | (new (...p: A4) => R4)
      | (new (...p: A5) => R5)
      | (new (...p: A6) => R6)
      | (new (...p: A7) => R7)
      | (new (...p: A8) => R8)
      | (new (...p: A9) => R9)
      | (new (...p: A10) => R10)
  : never;
/**
 * A constructor function with `unknown` parameters and return type.
 */
export type UnknownConstructor = new (...args: unknown[]) => unknown;
/**
 * Same as {@linkcode IsUselessOverloadInfo}, but for constructors.
 */
export type IsUselessConstructorOverloadInfo<FunctionType> = StrictEqualUsingTSInternalIdenticalToOperator<
  FunctionType,
  UnknownConstructor
>;
/**
 * For older versions of TypeScript, we need two separate workarounds to
 * get constructor overload info. First, we need need to use
 * {@linkcode DecreasingConstructorOverloadsInfoUnion} to get the overload
 * info for constructors with 1-10 overloads. Then, we need to filter out the
 * "useless" overloads that are present in older versions of TypeScript,
 * for parameterless constructors. To do this we use
 * {@linkcode IsUselessConstructorOverloadInfo} to remove useless overloads.
 *
 * @see {@link https://github.com/microsoft/TypeScript/issues/28867 | Related}
 */
export type TSPre53ConstructorOverloadsInfoUnion<ConstructorType> =
  Tuplify<DecreasingConstructorOverloadsInfoUnion<ConstructorType>> extends infer Tup
    ? Tup extends [infer Ctor]
      ? IsUselessConstructorOverloadInfo<Ctor> extends true
        ? never
        : Ctor
      : never
    : never;
/**
 * For versions of TypeScript below 5.3, we need to check for 10 overloads,
 * then 9, then 8, etc., to get a union of the overload variants.
 */
export type DecreasingConstructorOverloadsInfoUnion<ConstructorType> = ConstructorType extends {
  new (...args: infer A1): infer R1;
  new (...args: infer A2): infer R2;
  new (...args: infer A3): infer R3;
  new (...args: infer A4): infer R4;
  new (...args: infer A5): infer R5;
  new (...args: infer A6): infer R6;
  new (...args: infer A7): infer R7;
  new (...args: infer A8): infer R8;
  new (...args: infer A9): infer R9;
  new (...args: infer A10): infer R10;
}
  ?
      | (new (...p: A1) => R1)
      | (new (...p: A2) => R2)
      | (new (...p: A3) => R3)
      | (new (...p: A4) => R4)
      | (new (...p: A5) => R5)
      | (new (...p: A6) => R6)
      | (new (...p: A7) => R7)
      | (new (...p: A8) => R8)
      | (new (...p: A9) => R9)
      | (new (...p: A10) => R10)
  : ConstructorType extends {
        new (...args: infer A1): infer R1;
        new (...args: infer A2): infer R2;
        new (...args: infer A3): infer R3;
        new (...args: infer A4): infer R4;
        new (...args: infer A5): infer R5;
        new (...args: infer A6): infer R6;
        new (...args: infer A7): infer R7;
        new (...args: infer A8): infer R8;
        new (...args: infer A9): infer R9;
      }
    ?
        | (new (...p: A1) => R1)
        | (new (...p: A2) => R2)
        | (new (...p: A3) => R3)
        | (new (...p: A4) => R4)
        | (new (...p: A5) => R5)
        | (new (...p: A6) => R6)
        | (new (...p: A7) => R7)
        | (new (...p: A8) => R8)
        | (new (...p: A9) => R9)
    : ConstructorType extends {
          new (...args: infer A1): infer R1;
          new (...args: infer A2): infer R2;
          new (...args: infer A3): infer R3;
          new (...args: infer A4): infer R4;
          new (...args: infer A5): infer R5;
          new (...args: infer A6): infer R6;
          new (...args: infer A7): infer R7;
          new (...args: infer A8): infer R8;
        }
      ?
          | (new (...p: A1) => R1)
          | (new (...p: A2) => R2)
          | (new (...p: A3) => R3)
          | (new (...p: A4) => R4)
          | (new (...p: A5) => R5)
          | (new (...p: A6) => R6)
          | (new (...p: A7) => R7)
          | (new (...p: A8) => R8)
      : ConstructorType extends {
            new (...args: infer A1): infer R1;
            new (...args: infer A2): infer R2;
            new (...args: infer A3): infer R3;
            new (...args: infer A4): infer R4;
            new (...args: infer A5): infer R5;
            new (...args: infer A6): infer R6;
            new (...args: infer A7): infer R7;
          }
        ?
            | (new (...p: A1) => R1)
            | (new (...p: A2) => R2)
            | (new (...p: A3) => R3)
            | (new (...p: A4) => R4)
            | (new (...p: A5) => R5)
            | (new (...p: A6) => R6)
            | (new (...p: A7) => R7)
        : ConstructorType extends {
              new (...args: infer A1): infer R1;
              new (...args: infer A2): infer R2;
              new (...args: infer A3): infer R3;
              new (...args: infer A4): infer R4;
              new (...args: infer A5): infer R5;
              new (...args: infer A6): infer R6;
            }
          ?
              | (new (...p: A1) => R1)
              | (new (...p: A2) => R2)
              | (new (...p: A3) => R3)
              | (new (...p: A4) => R4)
              | (new (...p: A5) => R5)
              | (new (...p: A6) => R6)
          : ConstructorType extends {
                new (...args: infer A1): infer R1;
                new (...args: infer A2): infer R2;
                new (...args: infer A3): infer R3;
                new (...args: infer A4): infer R4;
                new (...args: infer A5): infer R5;
              }
            ?
                | (new (...p: A1) => R1)
                | (new (...p: A2) => R2)
                | (new (...p: A3) => R3)
                | (new (...p: A4) => R4)
                | (new (...p: A5) => R5)
            : ConstructorType extends {
                  new (...args: infer A1): infer R1;
                  new (...args: infer A2): infer R2;
                  new (...args: infer A3): infer R3;
                  new (...args: infer A4): infer R4;
                }
              ? (new (...p: A1) => R1) | (new (...p: A2) => R2) | (new (...p: A3) => R3) | (new (...p: A4) => R4)
              : ConstructorType extends {
                    new (...args: infer A1): infer R1;
                    new (...args: infer A2): infer R2;
                    new (...args: infer A3): infer R3;
                  }
                ? (new (...p: A1) => R1) | (new (...p: A2) => R2) | (new (...p: A3) => R3)
                : ConstructorType extends {
                      new (...args: infer A1): infer R1;
                      new (...args: infer A2): infer R2;
                    }
                  ? (new (...p: A1) => R1) | (new (...p: A2) => R2)
                  : ConstructorType extends new (...args: infer A1) => infer R1
                    ? new (...p: A1) => R1
                    : never;
/**
 * Get a union of overload variants for a constructor
 * {@linkcode ConstructorType}. Does a check for whether we can do the
 * one-shot 10-overload matcher (which works for ts\>5.3), and if not,
 * falls back to the more complicated utility.
 */
export type ConstructorOverloadsUnion<ConstructorType> =
  IsNever<TSPost53ConstructorOverloadsInfoUnion<new (a: 1) => any>> extends true
    ? TSPre53ConstructorOverloadsInfoUnion<ConstructorType>
    : TSPost53ConstructorOverloadsInfoUnion<ConstructorType>;
/**
 * Allows inferring any constructor using the `infer` keyword.
 */
export type InferConstructor<ConstructorType extends new (...args: any) => any> = ConstructorType;
/**
 * A union type of the parameters allowed for any overload
 * of constructor {@linkcode ConstructorType}.
 */
export type ConstructorOverloadParameters<ConstructorType> =
  ConstructorOverloadsUnion<ConstructorType> extends InferConstructor<infer Ctor> ? ConstructorParameters<Ctor> : never;
/**
 * Calculates the number of overloads for a given function type.
 */
export type NumOverloads<FunctionType> = UnionToTuple<OverloadsInfoUnion<FunctionType>>["length"];
