import type { Component } from "../tui.js";
/**
 * Box component - a container that applies padding and background to all children
 */
export declare class Box implements Component {
    children: Component[];
    private paddingX;
    private paddingY;
    private bgFn?;
    private cachedWidth?;
    private cachedChildLines?;
    private cachedBgSample?;
    private cachedLines?;
    constructor(paddingX?: number, paddingY?: number, bgFn?: (text: string) => string);
    addChild(component: Component): void;
    removeChild(component: Component): void;
    clear(): void;
    setBgFn(bgFn?: (text: string) => string): void;
    private invalidateCache;
    invalidate(): void;
    render(width: number): string[];
    private applyBg;
}
//# sourceMappingURL=box.d.ts.map