import type { AutocompleteProvider } from "../autocomplete.js";
import { type Component, type Focusable, type TUI } from "../tui.js";
import { type SelectListTheme } from "./select-list.js";
export interface EditorTheme {
    borderColor: (str: string) => string;
    selectList: SelectListTheme;
}
export interface EditorOptions {
    paddingX?: number;
}
export declare class Editor implements Component, Focusable {
    private state;
    /** Focusable interface - set by TUI when focus changes */
    focused: boolean;
    protected tui: TUI;
    private theme;
    private paddingX;
    private lastWidth;
    private scrollOffset;
    borderColor: (str: string) => string;
    private autocompleteProvider?;
    private autocompleteList?;
    private isAutocompleting;
    private autocompletePrefix;
    private pastes;
    private pasteCounter;
    private pasteBuffer;
    private isInPaste;
    private pendingShiftEnter;
    private history;
    private historyIndex;
    private killRing;
    private lastAction;
    private undoStack;
    onSubmit?: (text: string) => void;
    onChange?: (text: string) => void;
    disableSubmit: boolean;
    constructor(tui: TUI, theme: EditorTheme, options?: EditorOptions);
    getPaddingX(): number;
    setPaddingX(padding: number): void;
    setAutocompleteProvider(provider: AutocompleteProvider): void;
    /**
     * Add a prompt to history for up/down arrow navigation.
     * Called after successful submission.
     */
    addToHistory(text: string): void;
    private isEditorEmpty;
    private isOnFirstVisualLine;
    private isOnLastVisualLine;
    private navigateHistory;
    /** Internal setText that doesn't reset history state - used by navigateHistory */
    private setTextInternal;
    invalidate(): void;
    render(width: number): string[];
    handleInput(data: string): void;
    private layoutText;
    getText(): string;
    /**
     * Get text with paste markers expanded to their actual content.
     * Use this when you need the full content (e.g., for external editor).
     */
    getExpandedText(): string;
    getLines(): string[];
    getCursor(): {
        line: number;
        col: number;
    };
    setText(text: string): void;
    /**
     * Insert text at the current cursor position.
     * Used for programmatic insertion (e.g., clipboard image markers).
     * This is atomic for undo - single undo restores entire pre-insert state.
     */
    insertTextAtCursor(text: string): void;
    private insertCharacter;
    private handlePaste;
    private addNewLine;
    private handleBackspace;
    private moveToLineStart;
    private moveToLineEnd;
    private deleteToStartOfLine;
    private deleteToEndOfLine;
    private deleteWordBackwards;
    private deleteWordForward;
    private handleForwardDelete;
    /**
     * Build a mapping from visual lines to logical positions.
     * Returns an array where each element represents a visual line with:
     * - logicalLine: index into this.state.lines
     * - startCol: starting column in the logical line
     * - length: length of this visual line segment
     */
    private buildVisualLineMap;
    /**
     * Find the visual line index for the current cursor position.
     */
    private findCurrentVisualLine;
    private moveCursor;
    /**
     * Scroll by a page (direction: -1 for up, 1 for down).
     * Moves cursor by the page size while keeping it in bounds.
     */
    private pageScroll;
    private moveWordBackwards;
    /**
     * Yank (paste) the most recent kill ring entry at cursor position.
     */
    private yank;
    /**
     * Cycle through kill ring (only works immediately after yank or yank-pop).
     * Replaces the last yanked text with the previous entry in the ring.
     */
    private yankPop;
    /**
     * Insert text at cursor position (used by yank operations).
     */
    private insertYankedText;
    /**
     * Delete the previously yanked text (used by yank-pop).
     * The yanked text is derived from killRing[end] since it hasn't been rotated yet.
     */
    private deleteYankedText;
    /**
     * Add text to the kill ring.
     * If lastAction is "kill", accumulates with the previous entry.
     * @param text - The text to add
     * @param prepend - If accumulating, prepend (true) or append (false) to existing entry
     */
    private addToKillRing;
    private captureUndoSnapshot;
    private restoreUndoSnapshot;
    private pushUndoSnapshot;
    private undo;
    private moveWordForwards;
    private isAtStartOfMessage;
    private tryTriggerAutocomplete;
    private handleTabCompletion;
    private handleSlashCommandCompletion;
    private forceFileAutocomplete;
    private cancelAutocomplete;
    isShowingAutocomplete(): boolean;
    private updateAutocomplete;
}
//# sourceMappingURL=editor.d.ts.map