import { type Component, type Focusable } from "../tui.js";
/**
 * Input component - single-line text input with horizontal scrolling
 */
export declare class Input implements Component, Focusable {
    private value;
    private cursor;
    onSubmit?: (value: string) => void;
    onEscape?: () => void;
    /** Focusable interface - set by TUI when focus changes */
    focused: boolean;
    private pasteBuffer;
    private isInPaste;
    private pendingShiftEnter;
    getValue(): string;
    setValue(value: string): void;
    handleInput(data: string): void;
    private deleteWordBackwards;
    private moveWordBackwards;
    private moveWordForwards;
    private handlePaste;
    invalidate(): void;
    render(width: number): string[];
}
//# sourceMappingURL=input.d.ts.map