/**
 * TUI session selector for --resume flag
 */
import { ProcessTerminal, TUI } from "@mariozechner/pi-tui";
import { SessionSelectorComponent } from "../modes/interactive/components/session-selector.js";
/** Show TUI session selector and return selected session path or null if cancelled */
export async function selectSession(currentSessionsLoader, allSessionsLoader) {
    return new Promise((resolve) => {
        const ui = new TUI(new ProcessTerminal());
        let resolved = false;
        const selector = new SessionSelectorComponent(currentSessionsLoader, allSessionsLoader, (path) => {
            if (!resolved) {
                resolved = true;
                ui.stop();
                resolve(path);
            }
        }, () => {
            if (!resolved) {
                resolved = true;
                ui.stop();
                resolve(null);
            }
        }, () => {
            ui.stop();
            process.exit(0);
        }, () => ui.requestRender());
        ui.addChild(selector);
        ui.setFocus(selector.getSessionList());
        ui.start();
    });
}
//# sourceMappingURL=session-picker.js.map