/**
 * Provides git branch and extension statuses - data not otherwise accessible to extensions.
 * Token stats, model info available via ctx.sessionManager and ctx.model.
 */
export declare class FooterDataProvider {
    private extensionStatuses;
    private cachedBranch;
    private gitWatcher;
    private branchChangeCallbacks;
    constructor();
    /** Current git branch, null if not in repo, "detached" if detached HEAD */
    getGitBranch(): string | null;
    /** Extension status texts set via ctx.ui.setStatus() */
    getExtensionStatuses(): ReadonlyMap<string, string>;
    /** Subscribe to git branch changes. Returns unsubscribe function. */
    onBranchChange(callback: () => void): () => void;
    /** Internal: set extension status */
    setExtensionStatus(key: string, text: string | undefined): void;
    /** Internal: cleanup */
    dispose(): void;
    private setupGitWatcher;
}
/** Read-only view for extensions - excludes setExtensionStatus and dispose */
export type ReadonlyFooterDataProvider = Pick<FooterDataProvider, "getGitBranch" | "getExtensionStatuses" | "onBranchChange">;
//# sourceMappingURL=footer-data-provider.d.ts.map