/**
 * Represents a prompt template loaded from a markdown file
 */
export interface PromptTemplate {
    name: string;
    description: string;
    content: string;
    source: string;
}
/**
 * Parse command arguments respecting quoted strings (bash-style)
 * Returns array of arguments
 */
export declare function parseCommandArgs(argsString: string): string[];
/**
 * Substitute argument placeholders in template content
 * Supports:
 * - $1, $2, ... for positional args
 * - $@ and $ARGUMENTS for all args
 * - ${@:N} for args from Nth onwards (bash-style slicing)
 * - ${@:N:L} for L args starting from Nth
 *
 * Note: Replacement happens on the template string only. Argument values
 * containing patterns like $1, $@, or $ARGUMENTS are NOT recursively substituted.
 */
export declare function substituteArgs(content: string, args: string[]): string;
export interface LoadPromptTemplatesOptions {
    /** Working directory for project-local templates. Default: process.cwd() */
    cwd?: string;
    /** Agent config directory for global templates. Default: from getPromptsDir() */
    agentDir?: string;
}
/**
 * Load all prompt templates from:
 * 1. Global: agentDir/prompts/
 * 2. Project: cwd/{CONFIG_DIR_NAME}/prompts/
 */
export declare function loadPromptTemplates(options?: LoadPromptTemplatesOptions): PromptTemplate[];
/**
 * Expand a prompt template if it matches a template name.
 * Returns the expanded content or the original text if not a template.
 */
export declare function expandPromptTemplate(text: string, templates: PromptTemplate[]): string;
//# sourceMappingURL=prompt-templates.d.ts.map