import type { SkillsSettings } from "./settings-manager.js";
export interface SkillFrontmatter {
    name?: string;
    description?: string;
    [key: string]: unknown;
}
export interface Skill {
    name: string;
    description: string;
    filePath: string;
    baseDir: string;
    source: string;
}
export interface SkillWarning {
    skillPath: string;
    message: string;
}
export interface LoadSkillsResult {
    skills: Skill[];
    warnings: SkillWarning[];
}
export interface LoadSkillsFromDirOptions {
    /** Directory to scan for skills */
    dir: string;
    /** Source identifier for these skills */
    source: string;
}
/**
 * Load skills from a directory recursively.
 * Skills are directories containing a SKILL.md file with frontmatter including a description.
 */
export declare function loadSkillsFromDir(options: LoadSkillsFromDirOptions): LoadSkillsResult;
/**
 * Format skills for inclusion in a system prompt.
 * Uses XML format per Agent Skills standard.
 * See: https://agentskills.io/integrate-skills
 */
export declare function formatSkillsForPrompt(skills: Skill[]): string;
export interface LoadSkillsOptions extends SkillsSettings {
    /** Working directory for project-local skills. Default: process.cwd() */
    cwd?: string;
    /** Agent config directory for global skills. Default: ~/.pi/agent */
    agentDir?: string;
}
/**
 * Load skills from all configured locations.
 * Returns skills and any validation warnings.
 */
export declare function loadSkills(options?: LoadSkillsOptions): LoadSkillsResult;
//# sourceMappingURL=skills.d.ts.map