/**
 * System prompt construction and project context loading
 */
import type { SkillsSettings } from "./settings-manager.js";
import { type Skill } from "./skills.js";
import type { ToolName } from "./tools/index.js";
/** Resolve input as file path or literal string */
export declare function resolvePromptInput(input: string | undefined, description: string): string | undefined;
export interface LoadContextFilesOptions {
    /** Working directory to start walking up from. Default: process.cwd() */
    cwd?: string;
    /** Agent config directory for global context. Default: from getAgentDir() */
    agentDir?: string;
}
/**
 * Load all project context files in order:
 * 1. Global: agentDir/AGENTS.md or CLAUDE.md
 * 2. Parent directories (top-most first) down to cwd
 * Each returns {path, content} for separate messages
 */
export declare function loadProjectContextFiles(options?: LoadContextFilesOptions): Array<{
    path: string;
    content: string;
}>;
export interface BuildSystemPromptOptions {
    /** Custom system prompt (replaces default). */
    customPrompt?: string;
    /** Tools to include in prompt. Default: [read, bash, edit, write] */
    selectedTools?: ToolName[];
    /** Text to append to system prompt. */
    appendSystemPrompt?: string;
    /** Skills settings for discovery. */
    skillsSettings?: SkillsSettings;
    /** Working directory. Default: process.cwd() */
    cwd?: string;
    /** Agent config directory. Default: from getAgentDir() */
    agentDir?: string;
    /** Pre-loaded context files (skips discovery if provided). */
    contextFiles?: Array<{
        path: string;
        content: string;
    }>;
    /** Pre-loaded skills (skips discovery if provided). */
    skills?: Skill[];
}
/** Build the system prompt with tools, guidelines, and context */
export declare function buildSystemPrompt(options?: BuildSystemPromptOptions): string;
//# sourceMappingURL=system-prompt.d.ts.map