import { CancellableLoader, Container, Spacer, Text } from "@mariozechner/pi-tui";
import { DynamicBorder } from "./dynamic-border.js";
import { keyHint } from "./keybinding-hints.js";
/** Loader wrapped with borders for extension UI */
export class BorderedLoader extends Container {
    loader;
    constructor(tui, theme, message) {
        super();
        const borderColor = (s) => theme.fg("border", s);
        this.addChild(new DynamicBorder(borderColor));
        this.loader = new CancellableLoader(tui, (s) => theme.fg("accent", s), (s) => theme.fg("muted", s), message);
        this.addChild(this.loader);
        this.addChild(new Spacer(1));
        this.addChild(new Text(keyHint("selectCancel", "cancel"), 1, 0));
        this.addChild(new Spacer(1));
        this.addChild(new DynamicBorder(borderColor));
    }
    get signal() {
        return this.loader.signal;
    }
    set onAbort(fn) {
        this.loader.onAbort = fn;
    }
    handleInput(data) {
        this.loader.handleInput(data);
    }
    dispose() {
        this.loader.dispose();
    }
}
//# sourceMappingURL=bordered-loader.js.map