import { type Component, Container, type Focusable } from "@mariozechner/pi-tui";
import type { SessionInfo, SessionListProgress } from "../../../core/session-manager.js";
import { type SortMode } from "./session-selector-search.js";
/**
 * Custom session list component with multi-line items and search
 */
declare class SessionList implements Component, Focusable {
    private allSessions;
    private filteredSessions;
    private selectedIndex;
    private searchInput;
    private showCwd;
    private sortMode;
    private showPath;
    private confirmingDeletePath;
    private currentSessionFilePath?;
    onSelect?: (sessionPath: string) => void;
    onCancel?: () => void;
    onExit: () => void;
    onToggleScope?: () => void;
    onToggleSort?: () => void;
    onTogglePath?: (showPath: boolean) => void;
    onDeleteConfirmationChange?: (path: string | null) => void;
    onDeleteSession?: (sessionPath: string) => Promise<void>;
    onError?: (message: string) => void;
    private maxVisible;
    private _focused;
    get focused(): boolean;
    set focused(value: boolean);
    constructor(sessions: SessionInfo[], showCwd: boolean, sortMode: SortMode, currentSessionFilePath?: string);
    setSortMode(sortMode: SortMode): void;
    setSessions(sessions: SessionInfo[], showCwd: boolean): void;
    private filterSessions;
    private setConfirmingDeletePath;
    private startDeleteConfirmationForSelectedSession;
    invalidate(): void;
    render(width: number): string[];
    handleInput(keyData: string): void;
}
type SessionsLoader = (onProgress?: SessionListProgress) => Promise<SessionInfo[]>;
/**
 * Component that renders a session selector
 */
export declare class SessionSelectorComponent extends Container implements Focusable {
    private sessionList;
    private header;
    private scope;
    private sortMode;
    private currentSessions;
    private allSessions;
    private currentSessionsLoader;
    private allSessionsLoader;
    private onCancel;
    private requestRender;
    private currentLoading;
    private allLoading;
    private allLoadSeq;
    private _focused;
    get focused(): boolean;
    set focused(value: boolean);
    constructor(currentSessionsLoader: SessionsLoader, allSessionsLoader: SessionsLoader, onSelect: (sessionPath: string) => void, onCancel: () => void, onExit: () => void, requestRender: () => void, currentSessionFilePath?: string);
    private loadCurrentSessions;
    private toggleSortMode;
    private toggleScope;
    getSessionList(): SessionList;
}
export {};
//# sourceMappingURL=session-selector.d.ts.map