import type { ThinkingLevel } from "@mariozechner/pi-agent-core";
import { Container, SettingsList } from "@mariozechner/pi-tui";
export interface SettingsConfig {
    autoCompact: boolean;
    showImages: boolean;
    autoResizeImages: boolean;
    blockImages: boolean;
    enableSkillCommands: boolean;
    steeringMode: "all" | "one-at-a-time";
    followUpMode: "all" | "one-at-a-time";
    thinkingLevel: ThinkingLevel;
    availableThinkingLevels: ThinkingLevel[];
    currentTheme: string;
    availableThemes: string[];
    hideThinkingBlock: boolean;
    collapseChangelog: boolean;
    doubleEscapeAction: "fork" | "tree";
    showHardwareCursor: boolean;
    editorPaddingX: number;
    quietStartup: boolean;
}
export interface SettingsCallbacks {
    onAutoCompactChange: (enabled: boolean) => void;
    onShowImagesChange: (enabled: boolean) => void;
    onAutoResizeImagesChange: (enabled: boolean) => void;
    onBlockImagesChange: (blocked: boolean) => void;
    onEnableSkillCommandsChange: (enabled: boolean) => void;
    onSteeringModeChange: (mode: "all" | "one-at-a-time") => void;
    onFollowUpModeChange: (mode: "all" | "one-at-a-time") => void;
    onThinkingLevelChange: (level: ThinkingLevel) => void;
    onThemeChange: (theme: string) => void;
    onThemePreview?: (theme: string) => void;
    onHideThinkingBlockChange: (hidden: boolean) => void;
    onCollapseChangelogChange: (collapsed: boolean) => void;
    onDoubleEscapeActionChange: (action: "fork" | "tree") => void;
    onShowHardwareCursorChange: (enabled: boolean) => void;
    onEditorPaddingXChange: (padding: number) => void;
    onQuietStartupChange: (enabled: boolean) => void;
    onCancel: () => void;
}
/**
 * Main settings selector component.
 */
export declare class SettingsSelectorComponent extends Container {
    private settingsList;
    constructor(config: SettingsConfig, callbacks: SettingsCallbacks);
    getSettingsList(): SettingsList;
}
//# sourceMappingURL=settings-selector.d.ts.map