import { BaseLogger } from "./BaseLogger.js";
import { ILogObj, ILogObjMeta, ISettingsParam } from "./interfaces.js";
export * from "./interfaces.js";
export * from "./BaseLogger.js";
export declare class Logger<LogObj> extends BaseLogger<LogObj> {
    constructor(settings?: ISettingsParam<LogObj>, logObj?: LogObj);
    /**
     * Logs a message with a custom log level.
     * @param logLevelId    - Log level ID e.g. 0
     * @param logLevelName  - Log level name e.g. silly
     * @param args          - Multiple log attributes that should be logged out.
     */
    log(logLevelId: number, logLevelName: string, ...args: unknown[]): (LogObj & ILogObjMeta & ILogObj) | undefined;
    /**
     * Logs a silly message.
     * @param args  - Multiple log attributes that should be logged out.
     */
    silly(...args: unknown[]): (LogObj & ILogObjMeta) | undefined;
    /**
     * Logs a trace message.
     * @param args  - Multiple log attributes that should be logged out.
     */
    trace(...args: unknown[]): (LogObj & ILogObjMeta) | undefined;
    /**
     * Logs a debug message.
     * @param args  - Multiple log attributes that should be logged out.
     */
    debug(...args: unknown[]): (LogObj & ILogObjMeta) | undefined;
    /**
     * Logs an info message.
     * @param args  - Multiple log attributes that should be logged out.
     */
    info(...args: unknown[]): (LogObj & ILogObjMeta) | undefined;
    /**
     * Logs a warn message.
     * @param args  - Multiple log attributes that should be logged out.
     */
    warn(...args: unknown[]): (LogObj & ILogObjMeta) | undefined;
    /**
     * Logs an error message.
     * @param args  - Multiple log attributes that should be logged out.
     */
    error(...args: unknown[]): (LogObj & ILogObjMeta) | undefined;
    /**
     * Logs a fatal message.
     * @param args  - Multiple log attributes that should be logged out.
     */
    fatal(...args: unknown[]): (LogObj & ILogObjMeta) | undefined;
    /**
     *  Returns a child logger based on the current instance with inherited settings
     *
     * @param settings - Overwrite settings inherited from parent logger
     * @param logObj - Overwrite logObj for sub-logger
     */
    getSubLogger(settings?: ISettingsParam<LogObj>, logObj?: LogObj): Logger<LogObj>;
}
