/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * THIS FILE IS AUTOGENERATED by cddlconv 0.1.7.
 * Run `node tools/generate-bidi-types.mjs` to regenerate.
 * @see https://github.com/w3c/webdriver-bidi/blob/master/index.bs
 */
export type UserAgentClientHintsCommand = Emulation.SetClientHintsOverrideCommand;
export declare namespace Emulation {
    type SetClientHintsOverrideCommand = {
        method: 'emulation.setClientHintsOverride';
        params: {
            clientHints: Emulation.ClientHintsMetadata | null;
            contexts?: [string, ...string[]];
            userContexts?: [string, ...string[]];
        };
    };
    type SetClientHintsOverrideParameters = SetClientHintsOverrideCommand['params'];
}
export declare namespace Emulation {
    type ClientHintsMetadata = {
        brands?: [...Emulation.BrandVersion[]];
        fullVersionList?: [...Emulation.BrandVersion[]];
        platform?: string;
        platformVersion?: string;
        architecture?: string;
        model?: string;
        mobile?: boolean;
        bitness?: string;
        wow64?: boolean;
        formFactors?: [...string[]];
    };
}
export declare namespace Emulation {
    type BrandVersion = {
        brand: string;
        version: string;
    };
}
export declare namespace Emulation {
    type SetClientHintsOverrideResult = Record<string, never>;
}
