<h1 align="center">ArkType</h1>
<h3 align="center"><i>TypeScript's 1:1 validator, optimized from editor to runtime</i></h1>

ArkType is a runtime validation library that parses optimized validators from familiar, type-safe syntax.

It can be used to check external data like JSON payloads or forms at the boundaries of your code (similar to Zod).

<video
autoPlay
loop
controls
playsInline
muted
disablePictureInPicture
src="https://github.com/user-attachments/assets/69fdded6-50a9-402d-a28c-afa58db63c90"
/>

## Docs

See our [docs site](https://arktype.io)

## Contributions

We accept and encourage pull requests from outside ArkType. Planned work is tracked in [this GitHub project](https://github.com/orgs/arktypeio/projects/4).

Depending on your level of familiarity with type systems and TS generics, some parts of the codebase may be hard to jump into. That said, there's plenty of opportunities for more straightforward contributions. We'd generally recommend starting with one of these issues labeled [external-contributor-friendly](https://github.com/orgs/arktypeio/projects/4/?filterQuery=label%3A%22external-contributor-friendly%22).

If you're planning on submitting a non-trivial fix or a new feature, please [create an issue first](https://github.com/arktypeio/arktype/issues/new) so everyone's on the same page. The last thing we want is for you to spend time on a submission we're unable to merge.

When you're ready, check out our [guide](./.github/CONTRIBUTING.md) to get started!

## License

This project is licensed under the terms of the
[MIT license](./LICENSE).

## Code of Conduct

We will not tolerate any form of disrespect toward members of our community. Please refer to our [Code of Conduct](./.github/CODE_OF_CONDUCT.md) and reach out to david@arktype.io immediately if you've seen or experienced an interaction that may violate these standards.

## Sponsorship

We've been working full-time on this project for multiple years and it means a lot to have the community behind us.

If the project has been useful to you and you are in a financial position to do so, please chip in via [GitHub Sponsors](https://github.com/sponsors/arktypeio).

Otherwise, consider sending me an email (david@arktype.io) or [message me on Discord](https://arktype.io/discord) to let me know you're a fan of ArkType. Either would make my day!

### ArkSponsors ⛵

<table>
    <tr>
        <th>get-convex</th>
        <th>inspatiallabs</th>
        <th>sam-goodwin</th>
    </tr>
    <tr>
        <td>
            <a href="https://github.com/get-convex"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/get-convex"
            /></a>
        </td>
        <td>
            <a href="https://github.com/inspatiallabs"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/inspatiallabs"
            /></a>
        </td>
        <td>
            <a href="https://github.com/sam-goodwin"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/sam-goodwin"
            /></a>
        </td>
    </tr>
</table>

### Sponsors 🥰

<table>
    <tr>
        <th>tmm</th>
        <th>mewhhaha</th>
        <th>jahands</th>
        <th>drwpwrs</th>
        <th>Phalangers</th>
    </tr>
    <tr>
        <td>
            <a href="https://github.com/tmm"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/tmm"
            /></a>
        </td>
        <td>
            <a href="https://github.com/mewhhaha"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/mewhhaha"
            /></a>
        </td>
        <td>
            <a href="https://github.com/jahands"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/jahands"
            /></a>
        </td>
        <td>
            <a href="https://github.com/drwpwrs"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/drwpwrs"
            /></a>
        </td>
        <td>
            <a href="https://github.com/Phalangers"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/Phalangers"
            /></a>
        </td>
    </tr>
    <tr>
        <th>WilliamConnatser</th>
        <th>JameEnder</th>
        <th>tylim88</th>
    </tr>
    <tr>
        <td>
            <a href="https://github.com/WilliamConnatser"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/WilliamConnatser"
            /></a>
        </td>
        <td>
            <a href="https://github.com/JameEnder"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/JameEnder"
            /></a>
        </td>
        <td>
            <a href="https://github.com/tylim88"
                ><img
                    height="64px"
                    src="https://avatars.githubusercontent.com/tylim88"
            /></a>
        </td>
    </tr>
</table>
