import type { ArkErrors, arkKind, flatResolutionsOf } from "@ark/schema";
import type { Brand, inferred } from "@ark/util";
import type { distill, InferredMorph, Out, To } from "../attributes.ts";
import type { DeclarationParser } from "../declare.ts";
import type { FnParser } from "../fn.ts";
import type { GenericParser } from "../generic.ts";
import type { MatchParser } from "../match.ts";
import type { BoundModule, Module } from "../module.ts";
import type { inferDefinition, validateDefinition } from "../parser/definition.ts";
import { type bindThis, type Scope } from "../scope.ts";
import type { DefinitionParser, SchemaParser, Type, TypeParser } from "../type.ts";
import type { BaseType } from "../variants/base.ts";
import type { instantiateType } from "../variants/instantiate.ts";
import { arkBuiltins } from "./builtins.ts";
import { arkPrototypes } from "./constructors.ts";
import { number } from "./number.ts";
import { string } from "./string.ts";
import { arkTsGenerics, arkTsKeywords, object, unknown } from "./ts.ts";
export interface Ark extends Omit<Ark.keywords, keyof Ark.wrapped>, Ark.wrapped {
}
export declare namespace Ark {
    interface keywords extends arkTsKeywords.$, arkTsGenerics.$, arkPrototypes.keywords, arkBuiltins.$ {
    }
    interface wrapped extends arkPrototypes.wrapped {
        string: string.submodule;
        number: number.submodule;
        object: object.submodule;
        unknown: unknown.submodule;
    }
    type flat = flatResolutionsOf<Ark>;
    interface typeAttachments extends arkTsKeywords.$ {
        arrayIndex: arkPrototypes.$["Array"]["index"];
        Key: arkBuiltins.$["Key"];
        Record: arkTsGenerics.$["Record"];
        Date: arkPrototypes.$["Date"];
        Array: arkPrototypes.$["Array"]["root"];
    }
    interface boundTypeAttachments<$> extends Omit<BoundModule<typeAttachments, $>, arkKind> {
    }
}
export declare const ark: Scope<Ark>;
export declare const keywords: Module<Ark>;
export declare const type: TypeParser<{}>;
export declare namespace type {
    interface cast<to> {
        [inferred]?: to;
    }
    type errors = ArkErrors;
    type validate<def, $ = {}, args = bindThis<def>> = validateDefinition<def, $, args>;
    type instantiate<def, $ = {}, args = bindThis<def>> = instantiateType<inferDefinition<def, $, args>, $>;
    type infer<def, $ = {}, args = bindThis<def>> = inferDefinition<def, $, args>;
    namespace infer {
        type In<def, $ = {}, args = {}> = distill.In<inferDefinition<def, $, args>>;
        type Out<def, $ = {}, args = {}> = distill.Out<inferDefinition<def, $, args>>;
        namespace introspectable {
            type Out<def, $ = {}, args = {}> = distill.introspectable.Out<inferDefinition<def, $, args>>;
        }
    }
    type brand<t, id> = t extends InferredMorph<infer i, infer o> ? o["introspectable"] extends true ? (In: i) => To<Brand<o["t"], id>> : (In: i) => Out<Brand<o["t"], id>> : Brand<t, id>;
    /** @ts-ignore cast variance */
    interface Any<out t = any, $ = any> extends BaseType<t, $> {
    }
}
export type type<t = unknown, $ = {}> = Type<t, $>;
export declare const match: MatchParser<{}>;
export declare const fn: FnParser<{}>;
export declare const generic: GenericParser<{}>;
export declare const schema: SchemaParser<{}>;
export declare const define: DefinitionParser<{}>;
export declare const declare: DeclarationParser<{}>;
