import { $arkTypeRegistry, scope } from "../scope.js";
import { arkBuiltins } from "./builtins.js";
import { arkPrototypes } from "./constructors.js";
import { number } from "./number.js";
import { string } from "./string.js";
import { arkTsGenerics, arkTsKeywords, object, unknown } from "./ts.js";
export const ark = scope({
    ...arkTsKeywords,
    ...arkTsGenerics,
    ...arkPrototypes,
    ...arkBuiltins,
    string,
    number,
    object,
    unknown
}, { prereducedAliases: true, name: "ark" });
export const keywords = ark.export();
Object.assign($arkTypeRegistry.ambient, keywords);
$arkTypeRegistry.typeAttachments = {
    string: keywords.string.root,
    number: keywords.number.root,
    bigint: keywords.bigint,
    boolean: keywords.boolean,
    symbol: keywords.symbol,
    undefined: keywords.undefined,
    null: keywords.null,
    object: keywords.object.root,
    unknown: keywords.unknown.root,
    false: keywords.false,
    true: keywords.true,
    never: keywords.never,
    arrayIndex: keywords.Array.index,
    Key: keywords.Key,
    Record: keywords.Record,
    Array: keywords.Array.root,
    Date: keywords.Date
};
export const type = Object.assign(ark.type, 
// assign attachments newly parsed in keywords
// future scopes add these directly from the
// registry when their TypeParsers are instantiated
$arkTypeRegistry.typeAttachments);
export const match = ark.match;
export const fn = ark.fn;
export const generic = ark.generic;
export const schema = ark.schema;
export const define = ark.define;
export const declare = ark.declare;
