import { type BaseParseContext, type BaseRoot, type writeInvalidPropertyKeyMessage } from "@ark/schema";
import { Backslash, type anyOrNever, type Dict, type ErrorMessage, type ErrorType, type Key, type merge, type show } from "@ark/util";
import type { validateString } from "./ast/validate.ts";
import type { inferDefinition } from "./definition.ts";
import { type OptionalPropertyDefinition, type validateProperty } from "./property.ts";
export declare const parseObjectLiteral: (def: Dict, ctx: BaseParseContext) => BaseRoot;
export type inferObjectLiteral<def extends object, $, args> = show<"..." extends keyof def ? merge<inferDefinition<def["..."], $, args>, _inferObjectLiteral<def, $, args>> : _inferObjectLiteral<def, $, args>>;
/**
 * Infers the contents of an object literal, ignoring a spread definition
 */
type _inferObjectLiteral<def extends object, $, args> = {
    -readonly [k in keyof def as nonOptionalKeyFromEntry<k, def[k], $, args>]: inferDefinition<def[k], $, args>;
} & {
    -readonly [k in keyof def as optionalKeyFromEntry<k, def[k]>]?: def[k] extends OptionalPropertyDefinition<infer baseDef> ? inferDefinition<baseDef, $, args> : inferDefinition<def[k], $, args>;
};
export type validateObjectLiteral<def, $, args> = {
    [k in keyof def]: preparseKey<k> extends (infer parsedKey extends PreparsedKey) ? parsedKey extends PreparsedEntryKey<"index"> ? validateString<parsedKey["normalized"], $, args> extends (ErrorMessage<infer message>) ? ErrorType<message> : inferDefinition<parsedKey["normalized"], $, args> extends Key ? validateProperty<def[k], parsedKey["kind"], $, args> : ErrorMessage<writeInvalidPropertyKeyMessage<parsedKey["normalized"]>> : validateProperty<def[k], parsedKey["kind"], $, args> : never;
};
type nonOptionalKeyFromEntry<k extends PropertyKey, v, $, args> = preparseKey<k> extends infer parsedKey ? parsedKey extends PreparsedEntryKey<"required"> ? [
    v
] extends [OptionalPropertyDefinition] ? [
    v
] extends [anyOrNever] ? parsedKey["normalized"] : never : parsedKey["normalized"] : parsedKey extends PreparsedEntryKey<"index"> ? inferDefinition<parsedKey["normalized"], $, args> & Key : never : never;
type optionalKeyFromEntry<k extends PropertyKey, v> = preparseKey<k> extends infer parsedKey ? parsedKey extends PreparsedEntryKey<"optional"> ? parsedKey["normalized"] : v extends OptionalPropertyDefinition ? k : never : never;
export declare const writeInvalidUndeclaredBehaviorMessage: (actual: unknown) => string;
export declare const nonLeadingSpreadError = "Spread operator may only be used as the first key in an object";
export type PreparsedKey = PreparsedEntryKey | PreparsedSpecialKey;
type normalizedKeyKind<kind extends EntryKeyKind> = kind extends "index" ? string : Key;
export type PreparsedEntryKey<kind extends EntryKeyKind = EntryKeyKind, normalized extends normalizedKeyKind<kind> = normalizedKeyKind<kind>> = {
    kind: kind;
    normalized: normalized;
};
export type PreparsedSpecialKey<kind extends SpecialKeyKind = SpecialKeyKind> = {
    kind: kind;
};
declare namespace PreparsedKey {
    type from<t extends PreparsedKey> = t;
}
export type ParsedKeyKind = EntryKeyKind | SpecialKeyKind;
export type EntryKeyKind = "required" | "optional" | "index";
export type SpecialKeyKind = "spread" | "undeclared";
export type MetaKey = "..." | "+";
export type IndexKey<def extends string = string> = `[${def}]`;
export declare const preparseKey: (key: Key) => PreparsedKey;
export type preparseKey<k> = k extends symbol ? PreparsedKey.from<{
    kind: "required";
    normalized: k;
}> : k extends `${infer inner}?` ? inner extends `${infer baseName}${Backslash}` ? PreparsedKey.from<{
    kind: "required";
    normalized: `${baseName}?`;
}> : PreparsedKey.from<{
    kind: "optional";
    normalized: inner;
}> : k extends "+" ? {
    kind: "undeclared";
} : k extends "..." ? {
    kind: "spread";
} : k extends `${Backslash}${infer escapedMeta extends MetaKey}` ? PreparsedKey.from<{
    kind: "required";
    normalized: escapedMeta;
}> : k extends IndexKey<infer def> ? PreparsedKey.from<{
    kind: "index";
    normalized: def;
}> : PreparsedKey.from<{
    kind: "required";
    normalized: k extends (`${Backslash}${infer escapedIndexKey extends IndexKey}`) ? escapedIndexKey : k extends Key ? k : `${k & number}`;
}>;
export declare const writeInvalidSpreadTypeMessage: <def extends string>(def: def) => writeInvalidSpreadTypeMessage<def>;
export type writeInvalidSpreadTypeMessage<def extends string> = `Spread operand must resolve to an object literal type (was ${def})`;
export {};
