import type { DateLiteral } from "../../../attributes.ts";
export declare const isDateLiteral: (value: unknown) => value is DateLiteral;
export declare const isValidDate: (d: Date) => boolean;
export declare const extractDateLiteralSource: <literal extends DateLiteral>(literal: literal) => extractDateLiteralSource<literal>;
type extractDateLiteralSource<literal extends DateLiteral> = literal extends DateLiteral<infer source> ? source : never;
export declare const writeInvalidDateMessage: <source extends string>(source: source) => writeInvalidDateMessage<source>;
export type writeInvalidDateMessage<source extends string> = `'${source}' could not be parsed by the Date constructor`;
export type DateInput = ConstructorParameters<typeof Date>[0];
export type DateParseResult<errorOnFail extends boolean | string = boolean | string> = Date | (errorOnFail extends true | string ? never : undefined);
export declare const tryParseDate: <errorOnFail extends boolean | string>(source: string, errorOnFail?: errorOnFail) => DateParseResult<errorOnFail>;
export {};
