import { type BaseRoot, type BoundKind } from "@ark/schema";
import { type KeySet, type Scanner } from "@ark/util";
import type { DateLiteral } from "../../../attributes.ts";
import type { InferredAst } from "../../ast/infer.ts";
import type { astToString } from "../../ast/utils.ts";
import type { RootedRuntimeState, RuntimeState } from "../../reduce/dynamic.ts";
import { writeUnpairableComparatorMessage, type Comparator, type InvertedComparators, type MaxComparator } from "../../reduce/shared.ts";
import type { s, StaticState } from "../../reduce/static.ts";
import type { parseOperand } from "../operand/operand.ts";
export declare const parseBound: (s: RootedRuntimeState, start: ComparatorStartChar) => void;
export type parseBound<s extends StaticState, start extends ComparatorStartChar, unscanned extends string, $, args> = shiftComparator<start, unscanned> extends infer shiftResultOrError ? shiftResultOrError extends (Scanner.shiftResult<infer comparator extends Comparator, infer nextUnscanned>) ? s["root"] extends (InferredAst<Date | number, `${infer limit extends number | DateLiteral}`>) ? s.reduceLeftBound<s, limit, comparator, nextUnscanned> : parseRightBound<s.scanTo<s, nextUnscanned>, comparator, $, args> : shiftResultOrError : never;
type OneCharComparator = ">" | "<";
export type ComparatorStartChar = Comparator extends `${infer char}${string}` ? char : never;
export declare const comparatorStartChars: KeySet<ComparatorStartChar>;
declare const shiftComparator: (s: RuntimeState, start: ComparatorStartChar) => Comparator;
type shiftComparator<start extends ComparatorStartChar, unscanned extends string> = unscanned extends `=${infer nextUnscanned}` ? [`${start}=`, nextUnscanned] : [start & OneCharComparator, unscanned];
export declare const writeIncompatibleRangeMessage: (l: BoundKind, r: BoundKind) => string;
export declare const getBoundKinds: (comparator: Comparator, limit: number | DateLiteral, root: BaseRoot, boundKind: BoundExpressionKind) => BoundKind[];
export declare const parseRightBound: (s: RootedRuntimeState, comparator: Comparator) => void;
export type parseRightBound<s extends StaticState, comparator extends Comparator, $, args> = parseOperand<s, $, args> extends infer nextState extends StaticState ? nextState["root"] extends (InferredAst<unknown, `${infer limit extends number | DateLiteral}`>) ? s["branches"]["leftBound"] extends {} ? comparator extends MaxComparator ? s.reduceRange<s, s["branches"]["leftBound"]["limit"], s["branches"]["leftBound"]["comparator"], comparator, limit, nextState["unscanned"]> : s.error<writeUnpairableComparatorMessage<comparator>> : s.reduceSingleBound<s, comparator, limit, nextState["unscanned"]> : s.error<writeInvalidLimitMessage<comparator, astToString<nextState["root"]>, "right">> : never;
export declare const writeInvalidLimitMessage: <comparator extends Comparator, limit extends string | number, boundKind extends BoundExpressionKind>(comparator: comparator, limit: limit, boundKind: boundKind) => writeInvalidLimitMessage<comparator, limit, boundKind>;
export type writeInvalidLimitMessage<comparator extends Comparator, limit extends string | number, boundKind extends BoundExpressionKind> = `Comparator ${boundKind extends "left" ? InvertedComparators[comparator] : comparator} must be ${boundKind extends "left" ? "preceded" : "followed"} by a corresponding literal (was ${limit})`;
export type BoundExpressionKind = "left" | "right";
export {};
