import { type Scanner, type WhitespaceChar } from "@ark/util";
import type { RootedRuntimeState } from "../../reduce/dynamic.ts";
import type { StaticState, s } from "../../reduce/static.ts";
import { lookaheadIsFinalizing, type FinalizingLookahead } from "../tokens.ts";
import { parseBound, type ComparatorStartChar } from "./bounds.ts";
import { parseBrand } from "./brand.ts";
import { parseDivisor } from "./divisor.ts";
export declare const parseOperator: (s: RootedRuntimeState) => void;
export type parseOperator<s extends StaticState, $, args> = s["unscanned"] extends Scanner.shift<infer lookahead, infer unscanned> ? lookahead extends "[" ? unscanned extends Scanner.shift<"]", infer nextUnscanned> ? s.setRoot<s, [s["root"], "[]"], nextUnscanned> : s.error<incompleteArrayTokenMessage> : lookahead extends "|" ? unscanned extends Scanner.shift<">", infer nextUnscanned> ? s.reduceBranch<s, "|>", nextUnscanned> : s.reduceBranch<s, lookahead, unscanned> : lookahead extends "&" ? s.reduceBranch<s, lookahead, unscanned> : lookahead extends ")" ? s.finalizeGroup<s, unscanned> : lookaheadIsFinalizing<lookahead, unscanned> extends true ? s.finalize<s.scanTo<s, unscanned>, lookahead & FinalizingLookahead> : lookahead extends ComparatorStartChar ? parseBound<s, lookahead, unscanned, $, args> : lookahead extends "%" ? parseDivisor<s, unscanned> : lookahead extends "#" ? parseBrand<s, unscanned> : lookahead extends WhitespaceChar ? parseOperator<s.scanTo<s, unscanned>, $, args> : s.error<writeUnexpectedCharacterMessage<lookahead>> : s.finalize<s, "">;
export declare const writeUnexpectedCharacterMessage: <char extends string, shouldBe extends string>(char: char, shouldBe?: shouldBe) => writeUnexpectedCharacterMessage<char, shouldBe>;
export type writeUnexpectedCharacterMessage<char extends string, shouldBe extends string = ""> = `'${char}' is not allowed here${shouldBe extends "" ? "" : ` (should be ${shouldBe})`}`;
export declare const incompleteArrayTokenMessage = "Missing expected ']'";
type incompleteArrayTokenMessage = typeof incompleteArrayTokenMessage;
export {};
