import type { BaseParseContext, resolvableReferenceIn } from "@ark/schema";
import { type ErrorMessage } from "@ark/util";
import type { ArkAmbient } from "../config.ts";
import type { InnerParseResult, resolutionToAst } from "../scope.ts";
import type { inferAstRoot } from "./ast/infer.ts";
import { RuntimeState, type RootedRuntimeState } from "./reduce/dynamic.ts";
import type { StringifiablePrefixOperator } from "./reduce/shared.ts";
import type { s, StaticState } from "./reduce/static.ts";
import type { parseOperand } from "./shift/operand/operand.ts";
import { parseDefault } from "./shift/operator/default.ts";
import { writeUnexpectedCharacterMessage, type parseOperator } from "./shift/operator/operator.ts";
export declare const parseString: (def: string, ctx: BaseParseContext) => InnerParseResult;
/**
 * Try to parse the definition from right to left using the most common syntax.
 * This can be much more efficient for simple definitions.
 */
export type parseString<def extends string, $, args> = def extends keyof $ ? resolutionToAst<def, $[def]> : def extends `${infer child}[]` ? child extends keyof $ ? [
    resolutionToAst<child, $[child]>,
    "[]"
] : fullStringParse<s.initialize<def>, $, args> : fullStringParse<s.initialize<def>, $, args>;
export type inferString<def extends string, $, args> = inferAstRoot<parseString<def, $, args>, $, args>;
export type BaseCompletions<$, args, otherSuggestions extends string = never> = resolvableReferenceIn<$> | resolvableReferenceIn<ArkAmbient.$> | (keyof args & string) | StringifiablePrefixOperator | otherSuggestions;
export declare const fullStringParse: (s: RuntimeState) => InnerParseResult;
type fullStringParse<s extends StaticState, $, args> = extractFinalizedResult<parseUntilFinalizer<s, $, args>>;
export declare const parseUntilFinalizer: (s: RuntimeState) => RootedRuntimeState;
export type parseUntilFinalizer<s extends StaticState, $, args> = s["finalizer"] extends undefined ? parseUntilFinalizer<next<s, $, args>, $, args> : s;
declare const next: (s: RuntimeState) => void;
type next<s extends StaticState, $, args> = s["root"] extends undefined ? parseOperand<s, $, args> : parseOperator<s, $, args>;
export type extractFinalizedResult<s extends StaticState> = s["finalizer"] extends "" ? s["root"] : s["finalizer"] extends ErrorMessage ? s["finalizer"] : s["finalizer"] extends "?" ? [s["root"], "?"] : s["finalizer"] extends "=" ? parseDefault<s["root"], s["unscanned"]> : ErrorMessage<writeUnexpectedCharacterMessage<s["finalizer"] & string>>;
export {};
